/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.sctl;

import com.google.common.base.Optional;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.dal.show.ShowShardingCTLMergedResult;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLShowParser;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLShowStatement;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.FieldCountPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class ShardingCTLShowBackendHandler
extends AbstractBackendHandler {
    private final String sql;
    private final BackendConnection backendConnection;
    private MergedResult mergedResult;
    private int currentSequenceId;
    private int columnCount;
    private final List<ColumnType> columnTypes = new LinkedList<ColumnType>();

    public ShardingCTLShowBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql.toUpperCase().trim();
        this.backendConnection = backendConnection;
    }

    @Override
    protected CommandResponsePackets execute0() {
        Optional<ShardingCTLShowStatement> showStatement = new ShardingCTLShowParser(this.sql).doParse();
        if (!showStatement.isPresent()) {
            return new CommandResponsePackets(new ErrPacket(" please review your sctl format, should be sctl:show xxxx."));
        }
        switch (((ShardingCTLShowStatement)showStatement.get()).getValue()) {
            case "TRANSACTION_TYPE": {
                return this.createResponsePackets("TRANSACTION_TYPE", this.backendConnection.getTransactionType().name());
            }
            case "CACHED_CONNECTIONS": {
                return this.createResponsePackets("CACHED_CONNECTIONS", this.backendConnection.getConnectionSize());
            }
        }
        return new CommandResponsePackets(new ErrPacket(String.format(" could not support this sctl grammar [%s].", this.sql)));
    }

    private CommandResponsePackets createResponsePackets(String columnName, Object ... values) {
        this.mergedResult = new ShowShardingCTLMergedResult(Arrays.asList(values));
        int sequenceId = 0;
        FieldCountPacket fieldCountPacket = new FieldCountPacket(++sequenceId, 1);
        ArrayList<ColumnDefinition41Packet> columnDefinition41Packets = new ArrayList<ColumnDefinition41Packet>(1);
        columnDefinition41Packets.add(new ColumnDefinition41Packet(++sequenceId, "", "", "", columnName, "", 100, ColumnType.MYSQL_TYPE_VARCHAR, 0));
        QueryResponsePackets queryResponsePackets = new QueryResponsePackets(fieldCountPacket, columnDefinition41Packets, new EofPacket(++sequenceId));
        this.currentSequenceId = queryResponsePackets.getPackets().size();
        this.columnCount = queryResponsePackets.getColumnCount();
        this.columnTypes.addAll(queryResponsePackets.getColumnTypes());
        return queryResponsePackets;
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public ResultPacket getResultValue() throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>(this.columnCount);
        for (int columnIndex = 1; columnIndex <= this.columnCount; ++columnIndex) {
            data.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return new ResultPacket(++this.currentSequenceId, data, this.columnCount, this.columnTypes);
    }
}

