/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.frontend.common.executor.ChannelThreadExecutorGroup;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;

public abstract class FrontendHandler
extends ChannelInboundHandlerAdapter {
    private volatile boolean authorized;
    private volatile BackendConnection backendConnection = new BackendConnection(GlobalRegistry.getInstance().getTransactionType());

    public final void channelActive(ChannelHandlerContext context) {
        ChannelThreadExecutorGroup.getInstance().register(context.channel().id());
        this.handshake(context);
    }

    protected abstract void handshake(ChannelHandlerContext var1);

    public final void channelRead(ChannelHandlerContext context, Object message) {
        if (!this.authorized) {
            this.auth(context, (ByteBuf)message);
            this.authorized = true;
        } else {
            this.executeCommand(context, (ByteBuf)message);
        }
    }

    protected abstract void auth(ChannelHandlerContext var1, ByteBuf var2);

    protected abstract void executeCommand(ChannelHandlerContext var1, ByteBuf var2);

    public final void channelInactive(ChannelHandlerContext context) {
        context.fireChannelInactive();
        this.backendConnection.close(true);
        ChannelThreadExecutorGroup.getInstance().unregister(context.channel().id());
    }

    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }
}

