/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.common.executor;

import io.netty.channel.ChannelId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ChannelThreadExecutorGroup {
    private static final ChannelThreadExecutorGroup INSTANCE = new ChannelThreadExecutorGroup();
    private final Map<ChannelId, ExecutorService> executorServices = new ConcurrentHashMap<ChannelId, ExecutorService>();

    public static ChannelThreadExecutorGroup getInstance() {
        return INSTANCE;
    }

    public void register(ChannelId channelId) {
        this.executorServices.put(channelId, Executors.newSingleThreadExecutor());
    }

    public ExecutorService get(ChannelId channelId) {
        return this.executorServices.get(channelId);
    }

    public void unregister(ChannelId channelId) {
        this.executorServices.remove(channelId).shutdown();
    }

    private ChannelThreadExecutorGroup() {
    }
}

