/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.runtime.schema;

import com.google.common.eventbus.Subscribe;
import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.orchestration.internal.registry.config.event.MasterSlaveRuleChangedEvent;
import io.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import io.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import io.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import io.shardingsphere.shardingproxy.backend.BackendExecutorContext;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.metadata.ProxyTableMetaDataConnectionManager;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import java.util.Map;

public final class MasterSlaveSchema
extends LogicSchema {
    private MasterSlaveRule masterSlaveRule;
    private final ShardingMetaData metaData;

    public MasterSlaveSchema(String name, Map<String, DataSourceParameter> dataSources, MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isUsingRegistry) {
        super(name, dataSources);
        this.masterSlaveRule = this.createMasterSlaveRule(masterSlaveRuleConfig, isUsingRegistry);
        this.metaData = this.createShardingMetaData();
    }

    private MasterSlaveRule createMasterSlaveRule(MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationMasterSlaveRule(masterSlaveRuleConfig) : new MasterSlaveRule(masterSlaveRuleConfig);
    }

    private ShardingMetaData createShardingMetaData() {
        return new ShardingMetaData(this.getDataSourceURLs(this.getDataSources()), new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet()), DatabaseType.MySQL, BackendExecutorContext.getInstance().getExecuteEngine(), (TableMetaDataConnectionManager)new ProxyTableMetaDataConnectionManager(this.getBackendDataSource()), ((Integer)GlobalRegistry.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), ((Boolean)GlobalRegistry.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.CHECK_TABLE_METADATA_ENABLED)).booleanValue());
    }

    @Subscribe
    public synchronized void renew(MasterSlaveRuleChangedEvent masterSlaveRuleChangedEvent) {
        if (this.getName().equals(masterSlaveRuleChangedEvent.getShardingSchemaName())) {
            this.masterSlaveRule = new OrchestrationMasterSlaveRule(masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            ((OrchestrationMasterSlaveRule)this.masterSlaveRule).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
        }
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

