/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.convert;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.spi.TransactionalDataSourceConverter;
import io.shardingsphere.transaction.spi.xa.XATransactionManager;
import io.shardingsphere.transaction.xa.convert.datasource.XADataSourceFactory;
import io.shardingsphere.transaction.xa.convert.swap.DataSourceSwapperRegistry;
import io.shardingsphere.transaction.xa.manager.XATransactionManagerSPILoader;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class XADataSourceConverter
implements TransactionalDataSourceConverter {
    private final XATransactionManager xaTransactionManager = XATransactionManagerSPILoader.getInstance().getTransactionManager();

    public TransactionType getType() {
        return TransactionType.XA;
    }

    public Map<String, DataSource> convert(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(dataSourceMap.size(), 1.0f);
        try {
            for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
                DataSourceParameter parameter = DataSourceSwapperRegistry.getSwapper(entry.getValue().getClass()).swap(entry.getValue());
                DataSource dataSource = this.xaTransactionManager.wrapDataSource(databaseType, XADataSourceFactory.build(databaseType), entry.getKey(), parameter);
                result.put(entry.getKey(), dataSource);
            }
            return result;
        }
        catch (Exception ex) {
            return result;
        }
    }
}

