/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.convert.datasource;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.exception.ShardingException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.XADataSource;

public final class XADataSourceFactory {
    private static final Map<DatabaseType, String> XA_DRIVER_CLASS_NAMES = new HashMap<DatabaseType, String>(DatabaseType.values().length, 1.0f);

    public static XADataSource build(DatabaseType databaseType) {
        Class<?> xaDataSourceClass;
        String xaDataSourceClassName = XA_DRIVER_CLASS_NAMES.get(databaseType);
        try {
            xaDataSourceClass = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                xaDataSourceClass = Class.forName(xaDataSourceClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ShardingException("Failed to load [%s]", new Object[]{xaDataSourceClassName});
            }
        }
        try {
            return (XADataSource)xaDataSourceClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ShardingException("Failed to instance [%s]", new Object[]{xaDataSourceClassName});
        }
    }

    private XADataSourceFactory() {
    }

    static {
        XA_DRIVER_CLASS_NAMES.put(DatabaseType.H2, "org.h2.jdbcx.JdbcDataSource");
        XA_DRIVER_CLASS_NAMES.put(DatabaseType.MySQL, "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
        XA_DRIVER_CLASS_NAMES.put(DatabaseType.PostgreSQL, "org.postgresql.xa.PGXADataSource");
        XA_DRIVER_CLASS_NAMES.put(DatabaseType.Oracle, "oracle.jdbc.xa.client.OracleXADataSource");
        XA_DRIVER_CLASS_NAMES.put(DatabaseType.SQLServer, "com.microsoft.sqlserver.jdbc.SQLServerXADataSource");
    }
}

