/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.convert.datasource.dialect;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.datasource.dialect.OracleDataSourceMetaData;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.transaction.xa.convert.datasource.XAProperties;
import java.util.Properties;

public final class OracleXAProperties
implements XAProperties {
    @Override
    public Properties build(DataSourceParameter dataSourceParameter) {
        Properties result = new Properties();
        OracleDataSourceMetaData oracleMetaData = new OracleDataSourceMetaData(dataSourceParameter.getUrl());
        result.setProperty("user", dataSourceParameter.getUsername());
        result.setProperty("password", (String)Optional.fromNullable((Object)dataSourceParameter.getPassword()).or((Object)""));
        result.setProperty("serverName", oracleMetaData.getHostName());
        result.setProperty("portNumber", String.valueOf(oracleMetaData.getPort()));
        result.setProperty("databaseName", oracleMetaData.getSchemeName());
        return result;
    }
}

