/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.convert.datasource.dialect;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.datasource.dialect.SQLServerDataSourceMetaData;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.transaction.xa.convert.datasource.XAProperties;
import java.util.Properties;

public final class SQLServerXAProperties
implements XAProperties {
    @Override
    public Properties build(DataSourceParameter dataSourceParameter) {
        Properties result = new Properties();
        SQLServerDataSourceMetaData sqlServerMetaData = new SQLServerDataSourceMetaData(dataSourceParameter.getUrl());
        result.setProperty("user", dataSourceParameter.getUsername());
        result.setProperty("password", (String)Optional.fromNullable((Object)dataSourceParameter.getPassword()).or((Object)""));
        result.setProperty("serverName", sqlServerMetaData.getHostName());
        result.setProperty("portNumber", String.valueOf(sqlServerMetaData.getPort()));
        result.setProperty("databaseName", sqlServerMetaData.getSchemeName());
        return result;
    }
}

