/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.microprofile.config.spi.Converter;

class ImplicitConverters {
    private ImplicitConverters() {
    }

    static <T> Converter<T> getConverter(Class<? extends T> clazz) {
        Converter<? extends T> converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "of", String.class);
        if (converter == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "of", CharSequence.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", String.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", CharSequence.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", String.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", CharSequence.class)) == null && (converter = ImplicitConverters.getConverterFromConstructor(clazz, String.class)) == null) {
            converter = ImplicitConverters.getConverterFromConstructor(clazz, CharSequence.class);
        }
        return converter;
    }

    private static <T> Converter<T> getConverterFromConstructor(Class<? extends T> clazz, Class<? super String> paramType) {
        try {
            Constructor<T> declaredConstructor = clazz.getDeclaredConstructor(paramType);
            if (!declaredConstructor.isAccessible()) {
                declaredConstructor.setAccessible(true);
            }
            return new ConstructorConverter<T>(declaredConstructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static <T> Converter<T> getConverterFromStaticMethod(Class<? extends T> clazz, String methodName, Class<? super String> paramType) {
        try {
            Method method = clazz.getMethod(methodName, paramType);
            if (clazz != method.getReturnType()) {
                return null;
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return new StaticMethodConverter<T>(clazz, method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static class ConstructorConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 3350265927359848883L;
        private final Constructor<? extends T> ctor;

        public ConstructorConverter(Constructor<? extends T> ctor) {
            this.ctor = ctor;
        }

        public T convert(String value) {
            if (value.isEmpty()) {
                return null;
            }
            try {
                return this.ctor.newInstance(value);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }

        Object writeReplace() {
            return new Serialized(this.ctor.getDeclaringClass(), this.ctor.getParameterTypes()[0]);
        }

        static final class Serialized
        implements Serializable {
            private static final long serialVersionUID = -2903564775826815453L;
            private final Class<?> c;
            private final Class<?> p;

            Serialized(Class<?> c, Class<?> p) {
                this.c = c;
                this.p = p;
            }

            Object readResolve() throws ObjectStreamException {
                Constructor<?> ctor;
                if (!this.p.isAssignableFrom(String.class)) {
                    throw new InvalidObjectException("Invalid parameter type");
                }
                try {
                    ctor = this.c.getConstructor(this.p);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidObjectException("No matching constructor found");
                }
                if (!(Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) && Modifier.isPublic(ctor.getModifiers()) || ctor.isAccessible())) {
                    throw new InvalidObjectException("Deserialized constructor is not accessible");
                }
                return new ConstructorConverter(ctor);
            }
        }
    }

    static class StaticMethodConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 3350265927359848883L;
        private final Class<? extends T> clazz;
        private final Method method;

        StaticMethodConverter(Class<? extends T> clazz, Method method) {
            assert (clazz == method.getReturnType());
            this.clazz = clazz;
            this.method = method;
        }

        public T convert(String value) {
            if (value.isEmpty()) {
                return null;
            }
            try {
                return this.clazz.cast(this.method.invoke(null, value));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }

        Object writeReplace() {
            return new Serialized(this.method.getDeclaringClass(), this.method.getName(), this.method.getParameterTypes()[0]);
        }

        static final class Serialized
        implements Serializable {
            private static final long serialVersionUID = -6334004040897615452L;
            private final Class<?> c;
            private final String m;
            private final Class<?> p;

            Serialized(Class<?> c, String m, Class<?> p) {
                this.c = c;
                this.m = m;
                this.p = p;
            }

            Object readResolve() throws ObjectStreamException {
                Method method;
                if (!this.p.isAssignableFrom(String.class)) {
                    throw new InvalidObjectException("Invalid parameter type");
                }
                try {
                    method = this.c.getMethod(this.m, this.p);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidObjectException("No matching method found");
                }
                if (this.c != method.getReturnType()) {
                    throw new InvalidObjectException("Deserialized method has invalid return type");
                }
                if (!method.isAccessible()) {
                    throw new InvalidObjectException("Deserialized method is not accessible");
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new InvalidObjectException("Non static method " + method);
                }
                return new StaticMethodConverter(method.getReturnType(), method);
            }
        }
    }
}

