/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.Versions;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitDependencyManagementCollector
implements Action<Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(ImplicitDependencyManagementCollector.class);
    private final DependencyManagementContainer dependencyManagementContainer;
    private final DependencyManagementSettings dependencyManagementSettings;

    public ImplicitDependencyManagementCollector(DependencyManagementContainer dependencyManagementContainer, DependencyManagementSettings dependencyManagementSettings) {
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.dependencyManagementSettings = dependencyManagementSettings;
    }

    public void execute(Configuration root) {
        root.getIncoming().beforeResolve(resolvableDependencies -> {
            if (this.dependencyManagementSettings.isOverriddenByDependencies()) {
                root.getHierarchy().forEach(this::processConfiguration);
            }
        });
    }

    private void processConfiguration(Configuration configuration) {
        for (ModuleDependency dependency : this.getVersionedModuleDependencies(configuration)) {
            if (Versions.isDynamic(dependency.getVersion())) {
                logger.debug("Dependency '{}' in configuration '{}' has a dynamic version. The version will not be  added to the managed versions", (Object)dependency, (Object)configuration.getName());
                continue;
            }
            logger.debug("Adding managed version in configuration '{}' for dependency '{}'", (Object)configuration.getName(), (Object)dependency);
            this.dependencyManagementContainer.addImplicitManagedVersion(configuration, dependency.getGroup(), dependency.getName(), dependency.getVersion());
        }
    }

    private List<ModuleDependency> getVersionedModuleDependencies(Configuration configuration) {
        ArrayList<ModuleDependency> versionedModuleDependencies = new ArrayList<ModuleDependency>();
        for (Dependency dependency : configuration.getIncoming().getDependencies()) {
            if (!(dependency instanceof ModuleDependency) || dependency.getVersion() == null) continue;
            versionedModuleDependencies.add((ModuleDependency)dependency);
        }
        return versionedModuleDependencies;
    }
}

