/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject;

import com.google.inject.Binding;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.BeanEntry;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.LazyBeanEntry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class BeanCache<Q extends Annotation, T>
extends AtomicReference<Object> {
    private static final long serialVersionUID = 1L;
    private Map<Binding<T>, BeanEntry<Q, T>> readCache;
    private volatile boolean mutated;

    BeanCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEntry<Q, T> create(Q qualifier, Binding<T> binding, int rank) {
        LazyBeanEntry<Q, T> newBean;
        Object n;
        Object o;
        do {
            if ((o = this.get()) == null) {
                newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                n = newBean;
                continue;
            }
            if (o instanceof LazyBeanEntry) {
                LazyBeanEntry oldBean = (LazyBeanEntry)o;
                if (binding == oldBean.binding) {
                    return oldBean;
                }
                newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                n = BeanCache.createMap(oldBean, newBean);
                continue;
            }
            BeanCache beanCache = this;
            synchronized (beanCache) {
                Map map = (Map)o;
                newBean = (LazyBeanEntry<Q, T>)map.get(binding);
                if (newBean == null) {
                    newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                    map.put(binding, newBean);
                    this.mutated = true;
                }
                return newBean;
            }
        } while (!this.compareAndSet(o, n));
        if (n instanceof IdentityHashMap) {
            this.mutated = true;
        }
        return newBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Binding<T>, BeanEntry<Q, T>> flush() {
        if (this.mutated) {
            BeanCache beanCache = this;
            synchronized (beanCache) {
                if (this.mutated) {
                    this.readCache = (Map)((IdentityHashMap)this.get()).clone();
                    this.mutated = false;
                }
            }
        }
        return this.readCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Binding<T>> bindings() {
        Object o = this.get();
        if (o == null) {
            return Collections.EMPTY_SET;
        }
        if (o instanceof LazyBeanEntry) {
            return Collections.singleton(((LazyBeanEntry)o).binding);
        }
        BeanCache beanCache = this;
        synchronized (beanCache) {
            return new ArrayList<Binding<T>>(((Map)o).keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEntry<Q, T> remove(Binding<T> binding) {
        LazyBeanEntry oldBean;
        Object n;
        Object o;
        do {
            if ((o = this.get()) == null) {
                return null;
            }
            if (o instanceof LazyBeanEntry) {
                oldBean = (LazyBeanEntry)o;
                if (binding != oldBean.binding) {
                    return null;
                }
            } else {
                BeanCache beanCache = this;
                synchronized (beanCache) {
                    oldBean = (LazyBeanEntry)((Map)o).remove(binding);
                    if (oldBean != null) {
                        this.mutated = true;
                    }
                    return oldBean;
                }
            }
            n = null;
        } while (!this.compareAndSet(o, n));
        return oldBean;
    }

    private static Map createMap(LazyBeanEntry one, LazyBeanEntry two) {
        IdentityHashMap map = new IdentityHashMap(10);
        map.put(one.binding, one);
        map.put(two.binding, two);
        return map;
    }
}

