/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.info;

import io.spring.initializr.metadata.InitializrMetadataProvider;
import java.util.LinkedHashMap;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;

public class BomRangesInfoContributor
implements InfoContributor {
    private final InitializrMetadataProvider metadataProvider;

    public BomRangesInfoContributor(InitializrMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public void contribute(Info.Builder builder) {
        LinkedHashMap details = new LinkedHashMap();
        this.metadataProvider.get().getConfiguration().getEnv().getBoms().forEach((k, v) -> {
            if (v.getMappings() != null && !v.getMappings().isEmpty()) {
                LinkedHashMap bom = new LinkedHashMap();
                v.getMappings().forEach(it -> {
                    String requirement = "Spring Boot " + it.determineCompatibilityRangeRequirement();
                    bom.put(it.getVersion(), requirement);
                });
                details.put(k, bom);
            }
        });
        if (!details.isEmpty()) {
            builder.withDetail("bom-ranges", details);
        }
    }
}

