/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.buildsystem.maven.MavenBuild;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.BuildMetadataResolver;
import io.spring.initializr.metadata.InitializrMetadata;

public class KotlinJpaMavenBuildCustomizer
implements BuildCustomizer<MavenBuild> {
    private final BuildMetadataResolver buildMetadataResolver;

    public KotlinJpaMavenBuildCustomizer(InitializrMetadata metadata, ProjectDescription projectDescription) {
        this.buildMetadataResolver = new BuildMetadataResolver(metadata, projectDescription.getPlatformVersion());
    }

    @Override
    public void customize(MavenBuild build) {
        if (this.buildMetadataResolver.hasFacet((Build)build, "jpa")) {
            build.plugins().add("org.jetbrains.kotlin", "kotlin-maven-plugin", kotlinPlugin -> {
                kotlinPlugin.configuration(configuration -> configuration.configure("compilerPlugins", compilerPlugins -> compilerPlugins.add("plugin", "jpa")));
                kotlinPlugin.dependency("org.jetbrains.kotlin", "kotlin-maven-noarg", "${kotlin.version}");
            });
        }
    }
}

