/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.BuildSettings;
import io.spring.initializr.generator.buildsystem.Dependency;
import java.util.ArrayList;
import java.util.List;

public class GradleBuildSettings
extends BuildSettings {
    private final String sourceCompatibility;
    private final List<PluginMapping> pluginMappings;

    protected GradleBuildSettings(Builder builder) {
        super(builder);
        this.sourceCompatibility = builder.sourceCompatibility;
        this.pluginMappings = new ArrayList<PluginMapping>(builder.pluginMappings);
    }

    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public List<PluginMapping> getPluginMappings() {
        return this.pluginMappings;
    }

    public static class PluginMapping {
        private final String id;
        private final Dependency dependency;

        PluginMapping(String id, Dependency dependency) {
            this.id = id;
            this.dependency = dependency;
        }

        public String getId() {
            return this.id;
        }

        public Dependency getDependency() {
            return this.dependency;
        }
    }

    public static class Builder
    extends BuildSettings.Builder<Builder> {
        private String sourceCompatibility;
        private final List<PluginMapping> pluginMappings = new ArrayList<PluginMapping>();

        public Builder sourceCompatibility(String sourceCompatibility) {
            this.sourceCompatibility = sourceCompatibility;
            return (Builder)this.self();
        }

        public Builder mapPlugin(String id, Dependency pluginDependency) {
            if (pluginDependency.getVersion() == null || pluginDependency.getVersion().isProperty()) {
                throw new IllegalArgumentException("Mapping for plugin '" + id + "' must have a version");
            }
            this.pluginMappings.add(new PluginMapping(id, pluginDependency));
            return this;
        }

        @Override
        public GradleBuildSettings build() {
            return new GradleBuildSettings(this);
        }
    }
}

