/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import java.util.function.Consumer;

public class MavenDistributionManagement {
    private final String downloadUrl;
    private final DeploymentRepository repository;
    private final DeploymentRepository snapshotRepository;
    private final Site site;
    private final Relocation relocation;

    MavenDistributionManagement(Builder builder) {
        this.downloadUrl = builder.downloadUrl;
        this.repository = builder.repository.build();
        this.snapshotRepository = builder.snapshotRepository.build();
        this.site = builder.site.build();
        this.relocation = builder.relocation.build();
    }

    public boolean isEmpty() {
        return this.downloadUrl == null && this.repository.isEmpty() && this.snapshotRepository.isEmpty() && this.site.isEmpty() && this.relocation.isEmpty();
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public DeploymentRepository getRepository() {
        return this.repository;
    }

    public DeploymentRepository getSnapshotRepository() {
        return this.snapshotRepository;
    }

    public Site getSite() {
        return this.site;
    }

    public Relocation getRelocation() {
        return this.relocation;
    }

    public static class Relocation {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String message;

        Relocation(Builder builder) {
            this.groupId = builder.groupId;
            this.artifactId = builder.artifactId;
            this.version = builder.version;
            this.message = builder.message;
        }

        public boolean isEmpty() {
            return this.groupId == null && this.artifactId == null && this.version == null && this.message == null;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getMessage() {
            return this.message;
        }

        public static class Builder {
            private String groupId;
            private String artifactId;
            private String version;
            private String message;

            public Builder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public Builder artifactId(String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Relocation build() {
                return new Relocation(this);
            }
        }
    }

    public static class Site {
        private final String id;
        private final String name;
        private final String url;

        Site(Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this.url = builder.url;
        }

        public boolean isEmpty() {
            return this.id == null && this.name == null && this.url == null;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public static class Builder {
            private String id;
            private String name;
            private String url;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Site build() {
                return new Site(this);
            }
        }
    }

    public static class DeploymentRepository {
        private final String id;
        private final String name;
        private final String url;
        private final String layout;
        private final Boolean uniqueVersion;

        DeploymentRepository(Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this.url = builder.url;
            this.layout = builder.layout;
            this.uniqueVersion = builder.uniqueVersion;
        }

        public boolean isEmpty() {
            return this.id == null && this.name == null && this.url == null && this.layout == null && this.uniqueVersion == null;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLayout() {
            return this.layout;
        }

        public Boolean getUniqueVersion() {
            return this.uniqueVersion;
        }

        public static class Builder {
            private String id;
            private String name;
            private String url;
            private String layout;
            private Boolean uniqueVersion;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder layout(String layout) {
                this.layout = layout;
                return this;
            }

            public Builder uniqueVersion(Boolean uniqueVersion) {
                this.uniqueVersion = uniqueVersion;
                return this;
            }

            public DeploymentRepository build() {
                return new DeploymentRepository(this);
            }
        }
    }

    public static class Builder {
        private String downloadUrl;
        private DeploymentRepository.Builder repository = new DeploymentRepository.Builder();
        private DeploymentRepository.Builder snapshotRepository = new DeploymentRepository.Builder();
        private Site.Builder site = new Site.Builder();
        private Relocation.Builder relocation = new Relocation.Builder();

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder repository(Consumer<DeploymentRepository.Builder> repository) {
            repository.accept(this.repository);
            return this;
        }

        public Builder snapshotRepository(Consumer<DeploymentRepository.Builder> snapshotRepository) {
            snapshotRepository.accept(this.snapshotRepository);
            return this;
        }

        public Builder site(Consumer<Site.Builder> site) {
            site.accept(this.site);
            return this;
        }

        public Builder relocation(Consumer<Relocation.Builder> relocation) {
            relocation.accept(this.relocation);
            return this;
        }

        public MavenDistributionManagement build() {
            return new MavenDistributionManagement(this);
        }
    }
}

