/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

public class MavenScm {
    private final String connection;
    private final String developerConnection;
    private final String tag;
    private final String url;

    MavenScm(Builder builder) {
        this.connection = builder.connection;
        this.developerConnection = builder.developerConnection;
        this.tag = builder.tag;
        this.url = builder.url;
    }

    public boolean isEmpty() {
        return this.connection == null && this.developerConnection == null && this.tag == null && this.url == null;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getDeveloperConnection() {
        return this.developerConnection;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private String connection;
        private String developerConnection;
        private String tag;
        private String url;

        public Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        public Builder developerConnection(String developerConnection) {
            this.developerConnection = developerConnection;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public MavenScm build() {
            return new MavenScm(this);
        }
    }
}

