/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.kotlin;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import io.spring.initializr.generator.language.kotlin.KotlinStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class KotlinFunctionDeclaration
implements Annotatable {
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final String name;
    private final String returnType;
    private final List<KotlinModifier> modifiers;
    private final List<Parameter> parameters;
    private final List<KotlinStatement> statements;

    private KotlinFunctionDeclaration(String name, String returnType, List<KotlinModifier> modifiers, List<Parameter> parameters, List<KotlinStatement> statements) {
        this.name = name;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.parameters = parameters;
        this.statements = statements;
    }

    public static Builder function(String name) {
        return new Builder(name);
    }

    String getName() {
        return this.name;
    }

    String getReturnType() {
        return this.returnType;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    List<KotlinModifier> getModifiers() {
        return this.modifiers;
    }

    public List<KotlinStatement> getStatements() {
        return this.statements;
    }

    @Override
    public void annotate(Annotation annotation) {
        this.annotations.add(annotation);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public static final class Builder {
        private final String name;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<KotlinModifier> modifiers = new ArrayList<KotlinModifier>();
        private String returnType;

        private Builder(String name) {
            this.name = name;
        }

        public Builder modifiers(KotlinModifier ... modifiers) {
            this.modifiers = Arrays.asList(modifiers);
            return this;
        }

        public Builder returning(String returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder parameters(Parameter ... parameters) {
            this.parameters = Arrays.asList(parameters);
            return this;
        }

        public KotlinFunctionDeclaration body(KotlinStatement ... statements) {
            return new KotlinFunctionDeclaration(this.name, this.returnType, this.modifiers, this.parameters, Arrays.asList(statements));
        }
    }
}

