/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.kotlin;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.kotlin.KotlinExpression;
import io.spring.initializr.generator.language.kotlin.KotlinExpressionStatement;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class KotlinPropertyDeclaration
implements Annotatable {
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final boolean isVal;
    private final String name;
    private final String returnType;
    private final List<KotlinModifier> modifiers;
    private final KotlinExpressionStatement valueExpression;
    private final Accessor getter;
    private final Accessor setter;

    private KotlinPropertyDeclaration(Builder<?> builder) {
        this.name = ((Builder)builder).name;
        this.returnType = ((Builder)builder).returnType;
        this.modifiers = new ArrayList<KotlinModifier>(((Builder)builder).modifiers);
        this.isVal = ((Builder)builder).isVal;
        this.valueExpression = ((Builder)builder).initializerStatement;
        this.getter = ((Builder)builder).getter;
        this.setter = ((Builder)builder).setter;
    }

    public static ValBuilder val(String name) {
        return new ValBuilder(name);
    }

    public static VarBuilder var(String name) {
        return new VarBuilder(name);
    }

    boolean isVal() {
        return this.isVal;
    }

    String getName() {
        return this.name;
    }

    String getReturnType() {
        return this.returnType;
    }

    public List<KotlinModifier> getModifiers() {
        return this.modifiers;
    }

    KotlinExpressionStatement getValueExpression() {
        return this.valueExpression;
    }

    Accessor getGetter() {
        return this.getter;
    }

    Accessor getSetter() {
        return this.setter;
    }

    @Override
    public void annotate(Annotation annotation) {
        this.annotations.add(annotation);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    private static class SimpleValueExpression
    extends KotlinExpression {
        private final Object value;

        SimpleValueExpression(Object value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class Accessor
    implements Annotatable {
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private final KotlinExpressionStatement body;

        Accessor(AccessorBuilder<?> builder) {
            this.annotations.addAll(((AccessorBuilder)builder).annotations);
            this.body = ((AccessorBuilder)builder).body;
        }

        boolean isEmptyBody() {
            return this.body == null;
        }

        KotlinExpressionStatement getBody() {
            return this.body;
        }

        @Override
        public void annotate(Annotation annotation) {
            this.annotations.add(annotation);
        }

        @Override
        public List<Annotation> getAnnotations() {
            return Collections.unmodifiableList(this.annotations);
        }
    }

    public static final class AccessorBuilder<T extends Builder<T>> {
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private KotlinExpressionStatement body;
        private final T parent;
        private final Consumer<Accessor> accessorFunction;

        private AccessorBuilder(T parent, Consumer<Accessor> accessorFunction) {
            this.parent = parent;
            this.accessorFunction = accessorFunction;
        }

        public AccessorBuilder<?> withAnnotation(Annotation annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public AccessorBuilder<?> withBody(KotlinExpressionStatement expressionStatement) {
            this.body = expressionStatement;
            return this;
        }

        public T buildAccessor() {
            this.accessorFunction.accept(new Accessor(this));
            return this.parent;
        }

        /* synthetic */ AccessorBuilder(Builder x0, Consumer x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static final class VarBuilder
    extends Builder<VarBuilder> {
        private VarBuilder(String name) {
            super(name, false);
        }

        public KotlinPropertyDeclaration empty() {
            return new KotlinPropertyDeclaration(this);
        }

        @Override
        protected VarBuilder self() {
            return this;
        }
    }

    public static final class ValBuilder
    extends Builder<ValBuilder> {
        private ValBuilder(String name) {
            super(name, true);
        }

        @Override
        protected ValBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final boolean isVal;
        private final String name;
        private String returnType;
        private List<KotlinModifier> modifiers = new ArrayList<KotlinModifier>();
        private KotlinExpressionStatement initializerStatement;
        private Accessor getter;
        private Accessor setter;

        private Builder(String name, boolean isVal) {
            this.name = name;
            this.isVal = isVal;
        }

        protected abstract T self();

        public AccessorBuilder<T> getter() {
            return new AccessorBuilder(this, created -> {
                this.getter = created;
            }, null);
        }

        public AccessorBuilder<T> setter() {
            return new AccessorBuilder(this, created -> {
                this.setter = created;
            }, null);
        }

        public T returning(String returnType) {
            this.returnType = returnType;
            return this.self();
        }

        public T modifiers(KotlinModifier ... modifiers) {
            this.modifiers = Arrays.asList(modifiers);
            return this.self();
        }

        public KotlinPropertyDeclaration emptyValue() {
            return new KotlinPropertyDeclaration(this);
        }

        public KotlinPropertyDeclaration value(Object value) {
            this.initializerStatement = new KotlinExpressionStatement(new SimpleValueExpression(value));
            return new KotlinPropertyDeclaration(this);
        }
    }
}

