/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.project;

import io.spring.initializr.generator.buildsystem.BuildSystem;
import io.spring.initializr.generator.language.Language;
import io.spring.initializr.generator.packaging.Packaging;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.version.Version;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ProjectDescriptionDiff {
    private final ProjectDescription original;

    public ProjectDescriptionDiff(ProjectDescription original) {
        this.original = original.createCopy();
    }

    public ProjectDescription getOriginal() {
        return this.original;
    }

    public void ifPlatformVersionChanged(ProjectDescription current, BiConsumer<Version, Version> consumer) {
        if (!Objects.equals(this.original.getPlatformVersion(), current.getPlatformVersion())) {
            consumer.accept(this.original.getPlatformVersion(), current.getPlatformVersion());
        }
    }

    public void ifBuildSystemChanged(ProjectDescription current, BiConsumer<BuildSystem, BuildSystem> consumer) {
        if (!Objects.equals(this.original.getBuildSystem(), current.getBuildSystem())) {
            consumer.accept(this.original.getBuildSystem(), current.getBuildSystem());
        }
    }

    public void ifPackagingChanged(ProjectDescription current, BiConsumer<Packaging, Packaging> consumer) {
        if (!Objects.equals(this.original.getPackaging(), current.getPackaging())) {
            consumer.accept(this.original.getPackaging(), current.getPackaging());
        }
    }

    public void ifLanguageChanged(ProjectDescription current, BiConsumer<Language, Language> consumer) {
        if (!Objects.equals(this.original.getLanguage(), current.getLanguage())) {
            consumer.accept(this.original.getLanguage(), current.getLanguage());
        }
    }

    public void ifGroupIdChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getGroupId(), current.getGroupId())) {
            consumer.accept(this.original.getGroupId(), current.getGroupId());
        }
    }

    public void ifArtifactIdChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getArtifactId(), current.getArtifactId())) {
            consumer.accept(this.original.getArtifactId(), current.getArtifactId());
        }
    }

    public void ifVersionChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getVersion(), current.getVersion())) {
            consumer.accept(this.original.getVersion(), current.getVersion());
        }
    }

    public void ifNameChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getName(), current.getName())) {
            consumer.accept(this.original.getName(), current.getName());
        }
    }

    public void ifDescriptionChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getDescription(), current.getDescription())) {
            consumer.accept(this.original.getDescription(), current.getDescription());
        }
    }

    public void ifApplicationNameChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getApplicationName(), current.getApplicationName())) {
            consumer.accept(this.original.getApplicationName(), current.getApplicationName());
        }
    }

    public void ifPackageNameChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getPackageName(), current.getPackageName())) {
            consumer.accept(this.original.getPackageName(), current.getPackageName());
        }
    }

    public void ifBaseDirectoryChanged(ProjectDescription current, BiConsumer<String, String> consumer) {
        if (!Objects.equals(this.original.getBaseDirectory(), current.getBaseDirectory())) {
            consumer.accept(this.original.getBaseDirectory(), current.getBaseDirectory());
        }
    }
}

