/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.autoconfigure;

import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.io.SimpleIndentStrategy;
import io.spring.initializr.generator.io.template.MustacheTemplateRenderer;
import io.spring.initializr.generator.io.template.TemplateRenderer;
import io.spring.initializr.generator.project.ProjectDirectoryFactory;
import io.spring.initializr.metadata.DependencyMetadataProvider;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataBuilder;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import io.spring.initializr.metadata.InitializrProperties;
import io.spring.initializr.web.autoconfigure.InitializrModule;
import io.spring.initializr.web.autoconfigure.InitializrWebConfig;
import io.spring.initializr.web.controller.CommandLineMetadataController;
import io.spring.initializr.web.controller.DefaultProjectGenerationController;
import io.spring.initializr.web.controller.ProjectGenerationController;
import io.spring.initializr.web.controller.ProjectMetadataController;
import io.spring.initializr.web.controller.SpringCliDistributionController;
import io.spring.initializr.web.project.DefaultProjectRequestPlatformVersionTransformer;
import io.spring.initializr.web.project.DefaultProjectRequestToDescriptionConverter;
import io.spring.initializr.web.project.ProjectGenerationInvoker;
import io.spring.initializr.web.project.ProjectRequest;
import io.spring.initializr.web.project.ProjectRequestPlatformVersionTransformer;
import io.spring.initializr.web.support.DefaultDependencyMetadataProvider;
import io.spring.initializr.web.support.DefaultInitializrMetadataProvider;
import io.spring.initializr.web.support.InitializrMetadataUpdateStrategy;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.cache.CacheManager;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NoOpCache;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@AutoConfiguration(after={JacksonAutoConfiguration.class, RestTemplateAutoConfiguration.class})
@EnableConfigurationProperties(value={InitializrProperties.class})
public class InitializrAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ProjectDirectoryFactory projectDirectoryFactory() {
        return description -> Files.createTempDirectory("project-", new FileAttribute[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public IndentingWriterFactory indentingWriterFactory() {
        return IndentingWriterFactory.create((Function)new SimpleIndentStrategy("\t"));
    }

    @Bean
    @ConditionalOnMissingBean(value={TemplateRenderer.class})
    public MustacheTemplateRenderer templateRenderer(Environment environment, ObjectProvider<org.springframework.cache.CacheManager> cacheManager) {
        return new MustacheTemplateRenderer("classpath:/templates", this.determineCache(environment, (org.springframework.cache.CacheManager)cacheManager.getIfAvailable()));
    }

    private Cache determineCache(Environment environment, org.springframework.cache.CacheManager cacheManager) {
        Binder binder;
        boolean cache;
        if (cacheManager != null && (cache = ((Boolean)(binder = Binder.get((Environment)environment)).bind("spring.mustache.cache", Boolean.class).orElse((Object)true)).booleanValue())) {
            return cacheManager.getCache("initializr.templates");
        }
        return new NoOpCache("templates");
    }

    @Bean
    @ConditionalOnMissingBean(value={InitializrMetadataProvider.class})
    public InitializrMetadataProvider initializrMetadataProvider(InitializrProperties properties, ObjectProvider<InitializrMetadataUpdateStrategy> initializrMetadataUpdateStrategy) {
        InitializrMetadata metadata = InitializrMetadataBuilder.fromInitializrProperties((InitializrProperties)properties).build();
        return new DefaultInitializrMetadataProvider(metadata, (InitializrMetadataUpdateStrategy)initializrMetadataUpdateStrategy.getIfAvailable(() -> current -> current));
    }

    @Bean
    @ConditionalOnMissingBean
    public DependencyMetadataProvider dependencyMetadataProvider() {
        return new DefaultDependencyMetadataProvider();
    }

    @Order(value=0)
    private static class InitializrJCacheManagerCustomizer
    implements JCacheManagerCustomizer {
        private InitializrJCacheManagerCustomizer() {
        }

        public void customize(CacheManager cacheManager) {
            this.createMissingCache(cacheManager, "initializr.metadata", () -> this.config().setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)Duration.TEN_MINUTES)));
            this.createMissingCache(cacheManager, "initializr.dependency-metadata", this::config);
            this.createMissingCache(cacheManager, "initializr.project-resources", this::config);
            this.createMissingCache(cacheManager, "initializr.templates", this::config);
        }

        private void createMissingCache(CacheManager cacheManager, String cacheName, Supplier<MutableConfiguration<Object, Object>> config) {
            boolean cacheExist = StreamSupport.stream(cacheManager.getCacheNames().spliterator(), true).anyMatch(name -> name.equals(cacheName));
            if (!cacheExist) {
                cacheManager.createCache(cacheName, (javax.cache.configuration.Configuration)config.get());
            }
        }

        private MutableConfiguration<Object, Object> config() {
            return new MutableConfiguration().setStoreByValue(false).setManagementEnabled(true).setStatisticsEnabled(true);
        }
    }

    @Configuration
    @ConditionalOnClass(value={CacheManager.class})
    static class InitializrCacheConfiguration {
        InitializrCacheConfiguration() {
        }

        @Bean
        JCacheManagerCustomizer initializrCacheManagerCustomizer() {
            return new InitializrJCacheManagerCustomizer();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    static class InitializrWebConfiguration {
        InitializrWebConfiguration() {
        }

        @Bean
        InitializrWebConfig initializrWebConfig() {
            return new InitializrWebConfig();
        }

        @Bean
        @ConditionalOnMissingBean
        ProjectGenerationController<ProjectRequest> projectGenerationController(InitializrMetadataProvider metadataProvider, ObjectProvider<ProjectRequestPlatformVersionTransformer> platformVersionTransformer, ApplicationContext applicationContext) {
            ProjectGenerationInvoker<ProjectRequest> projectGenerationInvoker = new ProjectGenerationInvoker<ProjectRequest>(applicationContext, new DefaultProjectRequestToDescriptionConverter((ProjectRequestPlatformVersionTransformer)platformVersionTransformer.getIfAvailable(DefaultProjectRequestPlatformVersionTransformer::new)));
            return new DefaultProjectGenerationController(metadataProvider, projectGenerationInvoker);
        }

        @Bean
        @ConditionalOnMissingBean
        ProjectMetadataController projectMetadataController(InitializrMetadataProvider metadataProvider, DependencyMetadataProvider dependencyMetadataProvider) {
            return new ProjectMetadataController(metadataProvider, dependencyMetadataProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        CommandLineMetadataController commandLineMetadataController(InitializrMetadataProvider metadataProvider, TemplateRenderer templateRenderer) {
            return new CommandLineMetadataController(metadataProvider, templateRenderer);
        }

        @Bean
        @ConditionalOnMissingBean
        SpringCliDistributionController cliDistributionController(InitializrMetadataProvider metadataProvider) {
            return new SpringCliDistributionController(metadataProvider);
        }

        @Bean
        InitializrModule InitializrJacksonModule() {
            return new InitializrModule();
        }
    }
}

