/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.metadata.DefaultMetadataElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.web.client.RestTemplate;

class SpringBootMetadataReader {
    private static final Comparator<DefaultMetadataElement> VERSION_METADATA_ELEMENT_COMPARATOR = new VersionMetadataElementComparator();
    private final JsonNode content;

    SpringBootMetadataReader(ObjectMapper objectMapper, RestTemplate restTemplate, String url) throws IOException {
        this.content = objectMapper.readTree((String)restTemplate.getForObject(url, String.class, new Object[0]));
    }

    List<DefaultMetadataElement> getBootVersions() {
        ArrayNode releases = (ArrayNode)this.content.get("projectReleases");
        ArrayList<DefaultMetadataElement> list = new ArrayList<DefaultMetadataElement>();
        for (JsonNode node : releases) {
            DefaultMetadataElement versionMetadata = this.parseVersionMetadata(node);
            if (versionMetadata == null) continue;
            list.add(versionMetadata);
        }
        list.sort(VERSION_METADATA_ELEMENT_COMPARATOR.reversed());
        return list;
    }

    private DefaultMetadataElement parseVersionMetadata(JsonNode node) {
        String versionId = node.get("version").textValue();
        Version version = VersionParser.DEFAULT.safeParse(versionId);
        if (version == null) {
            return null;
        }
        DefaultMetadataElement versionMetadata = new DefaultMetadataElement();
        versionMetadata.setId(versionId);
        versionMetadata.setName(this.determineDisplayName(version));
        versionMetadata.setDefault(node.get("current").booleanValue());
        return versionMetadata;
    }

    private String determineDisplayName(Version version) {
        StringBuilder sb = new StringBuilder();
        sb.append(version.getMajor()).append(".").append(version.getMinor()).append(".").append(version.getPatch());
        if (version.getQualifier() != null) {
            sb.append(this.determineSuffix(version.getQualifier()));
        }
        return sb.toString();
    }

    private String determineSuffix(Version.Qualifier qualifier) {
        String id = qualifier.getId();
        if (id.equals("RELEASE")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" (");
        if (id.contains("SNAPSHOT")) {
            sb.append("SNAPSHOT");
        } else {
            sb.append(id);
            if (qualifier.getVersion() != null) {
                sb.append(qualifier.getVersion());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static class VersionMetadataElementComparator
    implements Comparator<DefaultMetadataElement> {
        private static final VersionParser versionParser = VersionParser.DEFAULT;

        private VersionMetadataElementComparator() {
        }

        @Override
        public int compare(DefaultMetadataElement o1, DefaultMetadataElement o2) {
            Version o1Version = versionParser.parse(o1.getId());
            Version o2Version = versionParser.parse(o2.getId());
            return o1Version.compareTo(o2Version);
        }
    }
}

