/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.template.utils;

import io.sundr.SundrException;
import io.sundr.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Templates {
    private static final String DOT = ".";

    private Templates() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(URL templateUrl) {
        try (InputStream in = templateUrl.openStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
        catch (IOException e) {
            throw SundrException.launderThrowable((Throwable)e);
        }
    }

    public static Optional<String> getExtension(String templatePath) {
        if (!Strings.isNullOrEmpty((String)templatePath) && templatePath.contains(DOT)) {
            return Optional.of(templatePath.substring(templatePath.lastIndexOf(DOT) + 1));
        }
        return Optional.empty();
    }

    public static Optional<String> getExtension(URL templateUrl) {
        return Templates.getExtension(templateUrl.getPath());
    }
}

