/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SSLOptions;

public class SharedWebSocketClient
implements WebSocketClient {
    public static final String SHARED_MAP_NAME = "__vertx.shared.webSocketClients";
    private final VertxInternal vertx;
    private final CloseFuture closeFuture;
    private final WebSocketClient delegate;

    public SharedWebSocketClient(VertxInternal vertx, CloseFuture closeFuture, WebSocketClient delegate) {
        this.vertx = vertx;
        this.closeFuture = closeFuture;
        this.delegate = delegate;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = closingCtx.promise();
        this.closeFuture.close(promise);
        return promise.future();
    }

    @Override
    public ClientWebSocket webSocket() {
        return this.delegate.webSocket();
    }

    @Override
    public void connect(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(options, handler);
    }

    @Override
    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        return this.delegate.connect(options);
    }

    @Override
    public Future<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return this.delegate.updateSSLOptions(options, force);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.delegate.isMetricsEnabled();
    }
}

