/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.HttpStatusException;

public class RedirectAuthHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements RedirectAuthHandler {
    private final String loginRedirectURL;
    private final String returnURLParam;

    public RedirectAuthHandlerImpl(AuthenticationProvider authProvider, String loginRedirectURL, String returnURLParam) {
        super(authProvider);
        this.loginRedirectURL = loginRedirectURL;
        this.returnURLParam = returnURLParam;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        Session session = context.session();
        if (session != null) {
            session.put(this.returnURLParam, context.request().uri());
            handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(302, this.loginRedirectURL)));
        } else {
            handler.handle((Object)Future.failedFuture((String)"No session - did you forget to include a SessionHandler?"));
        }
    }
}

