/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class NearMediaArgumentHelper {
    private final String mediaName;
    private final String mediaField;
    private final String data;
    private final File dataFile;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;

    public String build() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        String content = this.getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            fields.add(String.format("%s:%s", this.mediaField, Serializer.quote(content)));
        }
        if (this.certainty != null) {
            fields.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            fields.add(String.format("distance:%s", this.distance));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            fields.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        return String.format("%s:{%s}", this.mediaName, String.join((CharSequence)" ", fields));
    }

    private String getContent() {
        if (StringUtils.isNotBlank((CharSequence)this.data)) {
            if (this.data.startsWith("data:")) {
                String base64 = ";base64,";
                return this.data.substring(this.data.indexOf(base64) + base64.length());
            }
            return this.data;
        }
        if (this.dataFile != null) {
            return this.readFile(this.dataFile);
        }
        return null;
    }

    private String readFile(File file) {
        try {
            byte[] content = Files.readAllBytes(Paths.get(file.toURI()));
            return Base64.getEncoder().encodeToString(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    NearMediaArgumentHelper(String mediaName, String mediaField, String data, File dataFile, Float certainty, Float distance, String[] targetVectors) {
        this.mediaName = mediaName;
        this.mediaField = mediaField;
        this.data = data;
        this.dataFile = dataFile;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
    }

    public static NearMediaArgumentHelperBuilder builder() {
        return new NearMediaArgumentHelperBuilder();
    }

    public static class NearMediaArgumentHelperBuilder {
        private String mediaName;
        private String mediaField;
        private String data;
        private File dataFile;
        private Float certainty;
        private Float distance;
        private String[] targetVectors;

        NearMediaArgumentHelperBuilder() {
        }

        public NearMediaArgumentHelperBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public NearMediaArgumentHelperBuilder mediaField(String mediaField) {
            this.mediaField = mediaField;
            return this;
        }

        public NearMediaArgumentHelperBuilder data(String data) {
            this.data = data;
            return this;
        }

        public NearMediaArgumentHelperBuilder dataFile(File dataFile) {
            this.dataFile = dataFile;
            return this;
        }

        public NearMediaArgumentHelperBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearMediaArgumentHelperBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearMediaArgumentHelperBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public NearMediaArgumentHelper build() {
            return new NearMediaArgumentHelper(this.mediaName, this.mediaField, this.data, this.dataFile, this.certainty, this.distance, this.targetVectors);
        }

        public String toString() {
            return "NearMediaArgumentHelper.NearMediaArgumentHelperBuilder(mediaName=" + this.mediaName + ", mediaField=" + this.mediaField + ", data=" + this.data + ", dataFile=" + this.dataFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

