/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearAudioArgument;
import io.weaviate.client.v1.graphql.query.argument.NearDepthArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImuArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearThermalArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVideoArgument;
import io.weaviate.client.v1.graphql.query.argument.WhereArgument;
import io.weaviate.client.v1.graphql.query.builder.Query;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AggregateBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final String groupByClausePropertyName;
    private final WhereArgument withWhereFilter;
    private final AskArgument withAskArgument;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final NearImageArgument withNearImageFilter;
    private final NearAudioArgument withNearAudioFilter;
    private final NearVideoArgument withNearVideoFilter;
    private final NearDepthArgument withNearDepthFilter;
    private final NearThermalArgument withNearThermalFilter;
    private final NearImuArgument withNearImuFilter;
    private final Integer objectLimit;
    private final Integer limit;
    private final String tenant;

    private Stream<Argument> buildableArguments() {
        return Stream.of(this.withWhereFilter, this.withAskArgument, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter);
    }

    private Stream<Object> nonStringArguments() {
        return Stream.of(this.objectLimit, this.limit);
    }

    private Stream<String> stringArguments() {
        return Stream.of(this.groupByClausePropertyName, this.tenant);
    }

    private boolean includesFilterClause() {
        return this.buildableArguments().anyMatch(Objects::nonNull) || this.nonStringArguments().anyMatch(Objects::nonNull) || this.stringArguments().anyMatch(StringUtils::isNotBlank);
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.tenant)) {
                filters.add(String.format("tenant:%s", Serializer.quote(this.tenant)));
            }
            if (StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName)) {
                filters.add(String.format("groupBy:%s", Serializer.quote(this.groupByClausePropertyName)));
            }
            this.buildableArguments().filter(Objects::nonNull).map(Argument::build).forEach(filters::add);
            if (this.limit != null) {
                filters.add(String.format("limit:%s", this.limit));
            }
            if (this.objectLimit != null) {
                filters.add(String.format("objectLimit:%s", this.objectLimit));
            }
            return String.format("(%s)", String.join((CharSequence)" ", filters));
        }
        return "";
    }

    @Override
    public String buildQuery() {
        String fieldsClause = this.fields != null ? this.fields.build() : "";
        return String.format("{Aggregate{%s%s{%s}}}", Serializer.escape(this.className), this.createFilterClause(), fieldsClause);
    }

    AggregateBuilder(String className, Fields fields, String groupByClausePropertyName, WhereArgument withWhereFilter, AskArgument withAskArgument, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, NearVectorArgument withNearVectorFilter, NearImageArgument withNearImageFilter, NearAudioArgument withNearAudioFilter, NearVideoArgument withNearVideoFilter, NearDepthArgument withNearDepthFilter, NearThermalArgument withNearThermalFilter, NearImuArgument withNearImuFilter, Integer objectLimit, Integer limit, String tenant) {
        this.className = className;
        this.fields = fields;
        this.groupByClausePropertyName = groupByClausePropertyName;
        this.withWhereFilter = withWhereFilter;
        this.withAskArgument = withAskArgument;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearAudioFilter = withNearAudioFilter;
        this.withNearVideoFilter = withNearVideoFilter;
        this.withNearDepthFilter = withNearDepthFilter;
        this.withNearThermalFilter = withNearThermalFilter;
        this.withNearImuFilter = withNearImuFilter;
        this.objectLimit = objectLimit;
        this.limit = limit;
        this.tenant = tenant;
    }

    public static AggregateBuilderBuilder builder() {
        return new AggregateBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public String getGroupByClausePropertyName() {
        return this.groupByClausePropertyName;
    }

    public WhereArgument getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public NearAudioArgument getWithNearAudioFilter() {
        return this.withNearAudioFilter;
    }

    public NearVideoArgument getWithNearVideoFilter() {
        return this.withNearVideoFilter;
    }

    public NearDepthArgument getWithNearDepthFilter() {
        return this.withNearDepthFilter;
    }

    public NearThermalArgument getWithNearThermalFilter() {
        return this.withNearThermalFilter;
    }

    public NearImuArgument getWithNearImuFilter() {
        return this.withNearImuFilter;
    }

    public Integer getObjectLimit() {
        return this.objectLimit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String toString() {
        return "AggregateBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", groupByClausePropertyName=" + this.getGroupByClausePropertyName() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearAudioFilter=" + this.getWithNearAudioFilter() + ", withNearVideoFilter=" + this.getWithNearVideoFilter() + ", withNearDepthFilter=" + this.getWithNearDepthFilter() + ", withNearThermalFilter=" + this.getWithNearThermalFilter() + ", withNearImuFilter=" + this.getWithNearImuFilter() + ", objectLimit=" + this.getObjectLimit() + ", limit=" + this.getLimit() + ", tenant=" + this.getTenant() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateBuilder)) {
            return false;
        }
        AggregateBuilder other = (AggregateBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectLimit = this.getObjectLimit();
        Integer other$objectLimit = other.getObjectLimit();
        if (this$objectLimit == null ? other$objectLimit != null : !((Object)this$objectLimit).equals(other$objectLimit)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Fields this$fields = this.getFields();
        Fields other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$groupByClausePropertyName = this.getGroupByClausePropertyName();
        String other$groupByClausePropertyName = other.getGroupByClausePropertyName();
        if (this$groupByClausePropertyName == null ? other$groupByClausePropertyName != null : !this$groupByClausePropertyName.equals(other$groupByClausePropertyName)) {
            return false;
        }
        WhereArgument this$withWhereFilter = this.getWithWhereFilter();
        WhereArgument other$withWhereFilter = other.getWithWhereFilter();
        if (this$withWhereFilter == null ? other$withWhereFilter != null : !((Object)this$withWhereFilter).equals(other$withWhereFilter)) {
            return false;
        }
        AskArgument this$withAskArgument = this.getWithAskArgument();
        AskArgument other$withAskArgument = other.getWithAskArgument();
        if (this$withAskArgument == null ? other$withAskArgument != null : !((Object)this$withAskArgument).equals(other$withAskArgument)) {
            return false;
        }
        NearTextArgument this$withNearTextFilter = this.getWithNearTextFilter();
        NearTextArgument other$withNearTextFilter = other.getWithNearTextFilter();
        if (this$withNearTextFilter == null ? other$withNearTextFilter != null : !((Object)this$withNearTextFilter).equals(other$withNearTextFilter)) {
            return false;
        }
        NearObjectArgument this$withNearObjectFilter = this.getWithNearObjectFilter();
        NearObjectArgument other$withNearObjectFilter = other.getWithNearObjectFilter();
        if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !((Object)this$withNearObjectFilter).equals(other$withNearObjectFilter)) {
            return false;
        }
        NearVectorArgument this$withNearVectorFilter = this.getWithNearVectorFilter();
        NearVectorArgument other$withNearVectorFilter = other.getWithNearVectorFilter();
        if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !((Object)this$withNearVectorFilter).equals(other$withNearVectorFilter)) {
            return false;
        }
        NearImageArgument this$withNearImageFilter = this.getWithNearImageFilter();
        NearImageArgument other$withNearImageFilter = other.getWithNearImageFilter();
        if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !((Object)this$withNearImageFilter).equals(other$withNearImageFilter)) {
            return false;
        }
        NearAudioArgument this$withNearAudioFilter = this.getWithNearAudioFilter();
        NearAudioArgument other$withNearAudioFilter = other.getWithNearAudioFilter();
        if (this$withNearAudioFilter == null ? other$withNearAudioFilter != null : !((Object)this$withNearAudioFilter).equals(other$withNearAudioFilter)) {
            return false;
        }
        NearVideoArgument this$withNearVideoFilter = this.getWithNearVideoFilter();
        NearVideoArgument other$withNearVideoFilter = other.getWithNearVideoFilter();
        if (this$withNearVideoFilter == null ? other$withNearVideoFilter != null : !((Object)this$withNearVideoFilter).equals(other$withNearVideoFilter)) {
            return false;
        }
        NearDepthArgument this$withNearDepthFilter = this.getWithNearDepthFilter();
        NearDepthArgument other$withNearDepthFilter = other.getWithNearDepthFilter();
        if (this$withNearDepthFilter == null ? other$withNearDepthFilter != null : !((Object)this$withNearDepthFilter).equals(other$withNearDepthFilter)) {
            return false;
        }
        NearThermalArgument this$withNearThermalFilter = this.getWithNearThermalFilter();
        NearThermalArgument other$withNearThermalFilter = other.getWithNearThermalFilter();
        if (this$withNearThermalFilter == null ? other$withNearThermalFilter != null : !((Object)this$withNearThermalFilter).equals(other$withNearThermalFilter)) {
            return false;
        }
        NearImuArgument this$withNearImuFilter = this.getWithNearImuFilter();
        NearImuArgument other$withNearImuFilter = other.getWithNearImuFilter();
        if (this$withNearImuFilter == null ? other$withNearImuFilter != null : !((Object)this$withNearImuFilter).equals(other$withNearImuFilter)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregateBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectLimit = this.getObjectLimit();
        result = result * 59 + ($objectLimit == null ? 43 : ((Object)$objectLimit).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Fields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $groupByClausePropertyName = this.getGroupByClausePropertyName();
        result = result * 59 + ($groupByClausePropertyName == null ? 43 : $groupByClausePropertyName.hashCode());
        WhereArgument $withWhereFilter = this.getWithWhereFilter();
        result = result * 59 + ($withWhereFilter == null ? 43 : ((Object)$withWhereFilter).hashCode());
        AskArgument $withAskArgument = this.getWithAskArgument();
        result = result * 59 + ($withAskArgument == null ? 43 : ((Object)$withAskArgument).hashCode());
        NearTextArgument $withNearTextFilter = this.getWithNearTextFilter();
        result = result * 59 + ($withNearTextFilter == null ? 43 : ((Object)$withNearTextFilter).hashCode());
        NearObjectArgument $withNearObjectFilter = this.getWithNearObjectFilter();
        result = result * 59 + ($withNearObjectFilter == null ? 43 : ((Object)$withNearObjectFilter).hashCode());
        NearVectorArgument $withNearVectorFilter = this.getWithNearVectorFilter();
        result = result * 59 + ($withNearVectorFilter == null ? 43 : ((Object)$withNearVectorFilter).hashCode());
        NearImageArgument $withNearImageFilter = this.getWithNearImageFilter();
        result = result * 59 + ($withNearImageFilter == null ? 43 : ((Object)$withNearImageFilter).hashCode());
        NearAudioArgument $withNearAudioFilter = this.getWithNearAudioFilter();
        result = result * 59 + ($withNearAudioFilter == null ? 43 : ((Object)$withNearAudioFilter).hashCode());
        NearVideoArgument $withNearVideoFilter = this.getWithNearVideoFilter();
        result = result * 59 + ($withNearVideoFilter == null ? 43 : ((Object)$withNearVideoFilter).hashCode());
        NearDepthArgument $withNearDepthFilter = this.getWithNearDepthFilter();
        result = result * 59 + ($withNearDepthFilter == null ? 43 : ((Object)$withNearDepthFilter).hashCode());
        NearThermalArgument $withNearThermalFilter = this.getWithNearThermalFilter();
        result = result * 59 + ($withNearThermalFilter == null ? 43 : ((Object)$withNearThermalFilter).hashCode());
        NearImuArgument $withNearImuFilter = this.getWithNearImuFilter();
        result = result * 59 + ($withNearImuFilter == null ? 43 : ((Object)$withNearImuFilter).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    public static class AggregateBuilderBuilder {
        private String className;
        private Fields fields;
        private String groupByClausePropertyName;
        private AskArgument withAskArgument;
        private NearTextArgument withNearTextFilter;
        private NearObjectArgument withNearObjectFilter;
        private NearVectorArgument withNearVectorFilter;
        private NearImageArgument withNearImageFilter;
        private NearAudioArgument withNearAudioFilter;
        private NearVideoArgument withNearVideoFilter;
        private NearDepthArgument withNearDepthFilter;
        private NearThermalArgument withNearThermalFilter;
        private NearImuArgument withNearImuFilter;
        private Integer objectLimit;
        private Integer limit;
        private String tenant;
        private WhereArgument withWhereFilter;

        @Deprecated
        public AggregateBuilderBuilder withWhereFilter(WhereFilter whereFilter) {
            this.withWhereFilter = WhereArgument.builder().filter(whereFilter).build();
            return this;
        }

        public AggregateBuilderBuilder withWhereFilter(WhereArgument whereArgument) {
            this.withWhereFilter = whereArgument;
            return this;
        }

        AggregateBuilderBuilder() {
        }

        public AggregateBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public AggregateBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public AggregateBuilderBuilder groupByClausePropertyName(String groupByClausePropertyName) {
            this.groupByClausePropertyName = groupByClausePropertyName;
            return this;
        }

        public AggregateBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public AggregateBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearAudioFilter(NearAudioArgument withNearAudioFilter) {
            this.withNearAudioFilter = withNearAudioFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearVideoFilter(NearVideoArgument withNearVideoFilter) {
            this.withNearVideoFilter = withNearVideoFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearDepthFilter(NearDepthArgument withNearDepthFilter) {
            this.withNearDepthFilter = withNearDepthFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearThermalFilter(NearThermalArgument withNearThermalFilter) {
            this.withNearThermalFilter = withNearThermalFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearImuFilter(NearImuArgument withNearImuFilter) {
            this.withNearImuFilter = withNearImuFilter;
            return this;
        }

        public AggregateBuilderBuilder objectLimit(Integer objectLimit) {
            this.objectLimit = objectLimit;
            return this;
        }

        public AggregateBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AggregateBuilderBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public AggregateBuilder build() {
            return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereFilter, this.withAskArgument, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter, this.objectLimit, this.limit, this.tenant);
        }

        public String toString() {
            return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereFilter=" + this.withWhereFilter + ", withAskArgument=" + this.withAskArgument + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearAudioFilter=" + this.withNearAudioFilter + ", withNearVideoFilter=" + this.withNearVideoFilter + ", withNearDepthFilter=" + this.withNearDepthFilter + ", withNearThermalFilter=" + this.withNearThermalFilter + ", withNearImuFilter=" + this.withNearImuFilter + ", objectLimit=" + this.objectLimit + ", limit=" + this.limit + ", tenant=" + this.tenant + ")";
        }
    }
}

