/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.graphql.model.ExploreFields;
import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearAudioArgument;
import io.weaviate.client.v1.graphql.query.argument.NearDepthArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImuArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearThermalArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVideoArgument;
import io.weaviate.client.v1.graphql.query.builder.Query;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExploreBuilder
implements Query {
    private final ExploreFields[] fields;
    private final Integer offset;
    private final Integer limit;
    private final AskArgument withAskArgument;
    private final NearTextArgument withNearText;
    private final NearObjectArgument withNearObjectFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final NearImageArgument withNearImageFilter;
    private final NearAudioArgument withNearAudioFilter;
    private final NearVideoArgument withNearVideoFilter;
    private final NearDepthArgument withNearDepthFilter;
    private final NearThermalArgument withNearThermalFilter;
    private final NearImuArgument withNearImuFilter;

    private String createFilterClause() {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        Stream.of(this.withAskArgument, this.withNearText, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter).filter(Objects::nonNull).map(Argument::build).forEach(filters::add);
        if (this.limit != null) {
            filters.add(String.format("limit:%s", this.limit));
        }
        if (this.offset != null) {
            filters.add(String.format("offset:%s", this.offset));
        }
        return String.format("%s", String.join((CharSequence)" ", filters));
    }

    @Override
    public String buildQuery() {
        String fieldsClause = "";
        if (ArrayUtils.isNotEmpty((Object[])this.fields)) {
            fieldsClause = StringUtils.joinWith((String)",", (Object[])((Object[])this.fields));
        }
        String filterClause = this.createFilterClause();
        return String.format("{Explore(%s){%s}}", filterClause, fieldsClause);
    }

    ExploreBuilder(ExploreFields[] fields, Integer offset, Integer limit, AskArgument withAskArgument, NearTextArgument withNearText, NearObjectArgument withNearObjectFilter, NearVectorArgument withNearVectorFilter, NearImageArgument withNearImageFilter, NearAudioArgument withNearAudioFilter, NearVideoArgument withNearVideoFilter, NearDepthArgument withNearDepthFilter, NearThermalArgument withNearThermalFilter, NearImuArgument withNearImuFilter) {
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.withAskArgument = withAskArgument;
        this.withNearText = withNearText;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearAudioFilter = withNearAudioFilter;
        this.withNearVideoFilter = withNearVideoFilter;
        this.withNearDepthFilter = withNearDepthFilter;
        this.withNearThermalFilter = withNearThermalFilter;
        this.withNearImuFilter = withNearImuFilter;
    }

    public static ExploreBuilderBuilder builder() {
        return new ExploreBuilderBuilder();
    }

    public ExploreFields[] getFields() {
        return this.fields;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearTextArgument getWithNearText() {
        return this.withNearText;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public NearAudioArgument getWithNearAudioFilter() {
        return this.withNearAudioFilter;
    }

    public NearVideoArgument getWithNearVideoFilter() {
        return this.withNearVideoFilter;
    }

    public NearDepthArgument getWithNearDepthFilter() {
        return this.withNearDepthFilter;
    }

    public NearThermalArgument getWithNearThermalFilter() {
        return this.withNearThermalFilter;
    }

    public NearImuArgument getWithNearImuFilter() {
        return this.withNearImuFilter;
    }

    public String toString() {
        return "ExploreBuilder(fields=" + Arrays.deepToString((Object[])this.getFields()) + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearText=" + this.getWithNearText() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearAudioFilter=" + this.getWithNearAudioFilter() + ", withNearVideoFilter=" + this.getWithNearVideoFilter() + ", withNearDepthFilter=" + this.getWithNearDepthFilter() + ", withNearThermalFilter=" + this.getWithNearThermalFilter() + ", withNearImuFilter=" + this.getWithNearImuFilter() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExploreBuilder)) {
            return false;
        }
        ExploreBuilder other = (ExploreBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getFields(), (Object[])other.getFields())) {
            return false;
        }
        AskArgument this$withAskArgument = this.getWithAskArgument();
        AskArgument other$withAskArgument = other.getWithAskArgument();
        if (this$withAskArgument == null ? other$withAskArgument != null : !((Object)this$withAskArgument).equals(other$withAskArgument)) {
            return false;
        }
        NearTextArgument this$withNearText = this.getWithNearText();
        NearTextArgument other$withNearText = other.getWithNearText();
        if (this$withNearText == null ? other$withNearText != null : !((Object)this$withNearText).equals(other$withNearText)) {
            return false;
        }
        NearObjectArgument this$withNearObjectFilter = this.getWithNearObjectFilter();
        NearObjectArgument other$withNearObjectFilter = other.getWithNearObjectFilter();
        if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !((Object)this$withNearObjectFilter).equals(other$withNearObjectFilter)) {
            return false;
        }
        NearVectorArgument this$withNearVectorFilter = this.getWithNearVectorFilter();
        NearVectorArgument other$withNearVectorFilter = other.getWithNearVectorFilter();
        if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !((Object)this$withNearVectorFilter).equals(other$withNearVectorFilter)) {
            return false;
        }
        NearImageArgument this$withNearImageFilter = this.getWithNearImageFilter();
        NearImageArgument other$withNearImageFilter = other.getWithNearImageFilter();
        if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !((Object)this$withNearImageFilter).equals(other$withNearImageFilter)) {
            return false;
        }
        NearAudioArgument this$withNearAudioFilter = this.getWithNearAudioFilter();
        NearAudioArgument other$withNearAudioFilter = other.getWithNearAudioFilter();
        if (this$withNearAudioFilter == null ? other$withNearAudioFilter != null : !((Object)this$withNearAudioFilter).equals(other$withNearAudioFilter)) {
            return false;
        }
        NearVideoArgument this$withNearVideoFilter = this.getWithNearVideoFilter();
        NearVideoArgument other$withNearVideoFilter = other.getWithNearVideoFilter();
        if (this$withNearVideoFilter == null ? other$withNearVideoFilter != null : !((Object)this$withNearVideoFilter).equals(other$withNearVideoFilter)) {
            return false;
        }
        NearDepthArgument this$withNearDepthFilter = this.getWithNearDepthFilter();
        NearDepthArgument other$withNearDepthFilter = other.getWithNearDepthFilter();
        if (this$withNearDepthFilter == null ? other$withNearDepthFilter != null : !((Object)this$withNearDepthFilter).equals(other$withNearDepthFilter)) {
            return false;
        }
        NearThermalArgument this$withNearThermalFilter = this.getWithNearThermalFilter();
        NearThermalArgument other$withNearThermalFilter = other.getWithNearThermalFilter();
        if (this$withNearThermalFilter == null ? other$withNearThermalFilter != null : !((Object)this$withNearThermalFilter).equals(other$withNearThermalFilter)) {
            return false;
        }
        NearImuArgument this$withNearImuFilter = this.getWithNearImuFilter();
        NearImuArgument other$withNearImuFilter = other.getWithNearImuFilter();
        return !(this$withNearImuFilter == null ? other$withNearImuFilter != null : !((Object)this$withNearImuFilter).equals(other$withNearImuFilter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExploreBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getFields());
        AskArgument $withAskArgument = this.getWithAskArgument();
        result = result * 59 + ($withAskArgument == null ? 43 : ((Object)$withAskArgument).hashCode());
        NearTextArgument $withNearText = this.getWithNearText();
        result = result * 59 + ($withNearText == null ? 43 : ((Object)$withNearText).hashCode());
        NearObjectArgument $withNearObjectFilter = this.getWithNearObjectFilter();
        result = result * 59 + ($withNearObjectFilter == null ? 43 : ((Object)$withNearObjectFilter).hashCode());
        NearVectorArgument $withNearVectorFilter = this.getWithNearVectorFilter();
        result = result * 59 + ($withNearVectorFilter == null ? 43 : ((Object)$withNearVectorFilter).hashCode());
        NearImageArgument $withNearImageFilter = this.getWithNearImageFilter();
        result = result * 59 + ($withNearImageFilter == null ? 43 : ((Object)$withNearImageFilter).hashCode());
        NearAudioArgument $withNearAudioFilter = this.getWithNearAudioFilter();
        result = result * 59 + ($withNearAudioFilter == null ? 43 : ((Object)$withNearAudioFilter).hashCode());
        NearVideoArgument $withNearVideoFilter = this.getWithNearVideoFilter();
        result = result * 59 + ($withNearVideoFilter == null ? 43 : ((Object)$withNearVideoFilter).hashCode());
        NearDepthArgument $withNearDepthFilter = this.getWithNearDepthFilter();
        result = result * 59 + ($withNearDepthFilter == null ? 43 : ((Object)$withNearDepthFilter).hashCode());
        NearThermalArgument $withNearThermalFilter = this.getWithNearThermalFilter();
        result = result * 59 + ($withNearThermalFilter == null ? 43 : ((Object)$withNearThermalFilter).hashCode());
        NearImuArgument $withNearImuFilter = this.getWithNearImuFilter();
        result = result * 59 + ($withNearImuFilter == null ? 43 : ((Object)$withNearImuFilter).hashCode());
        return result;
    }

    public static class ExploreBuilderBuilder {
        private ExploreFields[] fields;
        private Integer offset;
        private Integer limit;
        private AskArgument withAskArgument;
        private NearTextArgument withNearText;
        private NearObjectArgument withNearObjectFilter;
        private NearVectorArgument withNearVectorFilter;
        private NearImageArgument withNearImageFilter;
        private NearAudioArgument withNearAudioFilter;
        private NearVideoArgument withNearVideoFilter;
        private NearDepthArgument withNearDepthFilter;
        private NearThermalArgument withNearThermalFilter;
        private NearImuArgument withNearImuFilter;

        ExploreBuilderBuilder() {
        }

        public ExploreBuilderBuilder fields(ExploreFields[] fields) {
            this.fields = fields;
            return this;
        }

        public ExploreBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public ExploreBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ExploreBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public ExploreBuilderBuilder withNearText(NearTextArgument withNearText) {
            this.withNearText = withNearText;
            return this;
        }

        public ExploreBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearAudioFilter(NearAudioArgument withNearAudioFilter) {
            this.withNearAudioFilter = withNearAudioFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearVideoFilter(NearVideoArgument withNearVideoFilter) {
            this.withNearVideoFilter = withNearVideoFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearDepthFilter(NearDepthArgument withNearDepthFilter) {
            this.withNearDepthFilter = withNearDepthFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearThermalFilter(NearThermalArgument withNearThermalFilter) {
            this.withNearThermalFilter = withNearThermalFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearImuFilter(NearImuArgument withNearImuFilter) {
            this.withNearImuFilter = withNearImuFilter;
            return this;
        }

        public ExploreBuilder build() {
            return new ExploreBuilder(this.fields, this.offset, this.limit, this.withAskArgument, this.withNearText, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter);
        }

        public String toString() {
            return "ExploreBuilder.ExploreBuilderBuilder(fields=" + Arrays.deepToString((Object[])this.fields) + ", offset=" + this.offset + ", limit=" + this.limit + ", withAskArgument=" + this.withAskArgument + ", withNearText=" + this.withNearText + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearAudioFilter=" + this.withNearAudioFilter + ", withNearVideoFilter=" + this.withNearVideoFilter + ", withNearDepthFilter=" + this.withNearDepthFilter + ", withNearThermalFilter=" + this.withNearThermalFilter + ", withNearImuFilter=" + this.withNearImuFilter + ")";
        }
    }
}

