/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.rbac.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.rbac.api.WeaviatePermission;
import io.weaviate.client.v1.rbac.model.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class PermissionAdder
extends AsyncBaseClient<Boolean>
implements AsyncClientResult<Boolean> {
    private String role;
    private List<Permission<?>> permissions = new ArrayList();

    public PermissionAdder(CloseableHttpAsyncClient httpClient, Config config, AccessTokenProvider tokenProvider) {
        super(httpClient, config, tokenProvider);
    }

    public PermissionAdder withRole(String name) {
        this.role = name;
        return this;
    }

    public PermissionAdder withPermissions(Permission<?> ... permissions) {
        this.permissions = Arrays.asList(permissions);
        return this;
    }

    public PermissionAdder withPermissions(Permission<?>[] ... permissions) {
        ArrayList all = new ArrayList();
        for (Permission<?>[] perm : permissions) {
            all.addAll(Arrays.asList(perm));
        }
        this.permissions = all;
        return this;
    }

    @Override
    public Future<Result<Boolean>> run(FutureCallback<Result<Boolean>> callback) {
        List<WeaviatePermission> permissions = WeaviatePermission.mergePermissions(this.permissions);
        return this.sendPostRequest(this.path(), (Object)new Body(permissions), callback, Result.voidToBooleanParser());
    }

    private String path() {
        return String.format("/authz/roles/%s/add-permissions", this.role);
    }

    private static class Body {
        public final List<?> permissions;

        @Generated
        public Body(List<?> permissions) {
            this.permissions = permissions;
        }
    }
}

