/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.schema.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.async.ResponseParser;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.async.schema.api.ClassGetter;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.schema.model.WeaviateClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;

public class VectorAdder
extends AsyncBaseClient<Boolean>
implements AsyncClientResult<Boolean> {
    private final ClassGetter getter;
    private String className;
    private Map<String, WeaviateClass.VectorConfig> addedVectors = new HashMap<String, WeaviateClass.VectorConfig>();

    public VectorAdder(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider) {
        super(client, config, tokenProvider);
        this.getter = new ClassGetter(client, config, tokenProvider);
    }

    public VectorAdder withClassName(String className) {
        this.className = className;
        return this;
    }

    public VectorAdder withVectorConfig(String name, WeaviateClass.VectorConfig vector) {
        this.addedVectors.put(name, vector);
        return this;
    }

    public VectorAdder withVectorConfig(Map<String, WeaviateClass.VectorConfig> vectors) {
        this.addedVectors = Collections.unmodifiableMap(vectors);
        return this;
    }

    @Override
    public Future<Result<Boolean>> run(FutureCallback<Result<Boolean>> callback) {
        CompletableFuture<Result> getClass = CompletableFuture.supplyAsync(() -> {
            try {
                return this.getter.withClassName(this.className).run().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        });
        CompletionStage addVectors = getClass.thenApplyAsync(result -> {
            if (result.getError() != null) {
                return result.toErrorResult();
            }
            WeaviateClass cls = (WeaviateClass)result.getResult();
            this.addedVectors.entrySet().stream().forEach(vector -> cls.getVectorConfig().putIfAbsent((String)vector.getKey(), (WeaviateClass.VectorConfig)vector.getValue()));
            String path = String.format("/schema/%s", UrlEncoder.encodePathParam(this.className));
            try {
                return this.sendPutRequest(path, (Object)cls, callback, new ResponseParser<Boolean>(){

                    @Override
                    public Result<Boolean> parse(HttpResponse response, String body, ContentType contentType) {
                        Response<WeaviateClass> resp = this.serializer.toResponse(response.getCode(), body, WeaviateClass.class);
                        return new Result<Boolean>(response.getCode(), response.getCode() <= 299, resp.getErrors());
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        });
        return addVectors;
    }
}

