/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpAdapter;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpHandler;
import brave.http.HttpRequest;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;

public final class HttpClientHandler<Req, Resp>
extends HttpHandler {
    final Tracer tracer;
    @Nullable
    final HttpClientAdapter<Req, Resp> adapter;
    final Sampler sampler;
    final SamplerFunction<HttpRequest> httpSampler;
    @Nullable
    final String serverName;
    final TraceContext.Injector<HttpClientRequest> defaultInjector;

    public static HttpClientHandler<HttpClientRequest, HttpClientResponse> create(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        return new HttpClientHandler<HttpClientRequest, HttpClientResponse>(httpTracing, null);
    }

    @Deprecated
    public static <Req, Resp> HttpClientHandler<Req, Resp> create(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        if (adapter == null) {
            throw new NullPointerException("adapter == null");
        }
        return new HttpClientHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpClientHandler(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        super(httpTracing.tracing().currentTraceContext(), httpTracing.clientParser());
        this.adapter = adapter;
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.tracing().sampler();
        this.httpSampler = httpTracing.clientRequestSampler();
        this.serverName = !"".equals(httpTracing.serverName()) ? httpTracing.serverName() : null;
        this.defaultInjector = httpTracing.tracing().propagation().injector(HttpClientRequest.SETTER);
    }

    public Span handleSend(HttpClientRequest request) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpan(this.httpSampler, (Object)request));
    }

    public Span handleSend(HttpClientRequest request, Span span) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        this.defaultInjector.inject(span.context(), (Object)request);
        return this.handleStart(new HttpClientRequest.ToHttpAdapter(request), request.unwrap(), span);
    }

    @Deprecated
    public Span handleSend(TraceContext.Injector<Req> injector, Req request) {
        return this.handleSend(injector, request, request);
    }

    @Deprecated
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request) {
        return this.handleSend(injector, carrier, request, this.nextSpan(request));
    }

    @Deprecated
    public Span handleSend(TraceContext.Injector<Req> injector, Req request, Span span) {
        return this.handleSend(injector, request, request, span);
    }

    @Deprecated
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request, Span span) {
        injector.inject(span.context(), carrier);
        return this.handleStart(this.adapter, request, span);
    }

    <Req1> void parseRequest(HttpAdapter<Req1, ?> adapter, Req1 request, Span span) {
        span.kind(Span.Kind.CLIENT);
        if (this.serverName != null) {
            span.remoteServiceName(this.serverName);
        }
        this.parser.request(adapter, request, span.customizer());
    }

    @Deprecated
    public Span nextSpan(Req request) {
        HttpClientRequest.FromHttpAdapter<Req> clientRequest = request instanceof HttpClientRequest ? (HttpClientRequest.FromHttpAdapter<Req>)((Object)request) : new HttpClientRequest.FromHttpAdapter<Req>(this.adapter, request);
        return this.tracer.nextSpan(this.httpSampler, clientRequest);
    }

    public void handleReceive(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (response instanceof HttpClientResponse) {
            HttpClientResponse.Adapter adapter = new HttpClientResponse.Adapter((HttpClientResponse)response);
            this.handleFinish(adapter, adapter.unwrapped, error, span);
        } else {
            this.handleFinish(this.adapter, response, error, span);
        }
    }
}

