/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.activemq;

import java.io.IOException;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSender;
import org.apache.activemq.ActiveMQConnectionFactory;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Sender;
import zipkin2.reporter.activemq.ActiveMQConn;
import zipkin2.reporter.activemq.LazyInit;

public final class ActiveMQSender
extends Sender {
    final Encoding encoding;
    final int messageMaxBytes;
    final BytesMessageEncoder encoder;
    final LazyInit lazyInit;
    volatile ActiveMQConn conn;
    volatile boolean closeCalled;

    public static ActiveMQSender create(String brokerUrl) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(brokerUrl);
        return ActiveMQSender.newBuilder().connectionFactory(connectionFactory).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    ActiveMQSender(Builder builder) {
        this.encoding = builder.encoding;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.encoder = BytesMessageEncoder.forEncoding((Encoding)this.encoding);
        this.lazyInit = new LazyInit(builder);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding.listSizeInBytes(encodedSizeInBytes);
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding.listSizeInBytes(encodedSpans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        byte[] message = this.encoder.encode(encodedSpans);
        return new ActiveMQCall(message);
    }

    public CheckResult check() {
        try {
            this.lazyInit.get();
        }
        catch (IOException | Error | RuntimeException e) {
            Call.propagateIfFatal((Throwable)e);
            return CheckResult.failed((Throwable)e);
        }
        return this.lazyInit.result.checkResult;
    }

    public void close() {
        this.closeCalled = true;
        this.lazyInit.close();
    }

    public final String toString() {
        return "ActiveMQSender{brokerURL=" + this.lazyInit.connectionFactory.getBrokerURL() + ", queue=" + this.lazyInit.queue + "}";
    }

    static IOException ioException(String prefix, JMSException e) {
        Exception cause = e.getLinkedException();
        if (cause instanceof IOException) {
            return new IOException(prefix + ActiveMQSender.message(cause), cause);
        }
        return new IOException(prefix + ActiveMQSender.message((Exception)((Object)e)), e);
    }

    static String message(Exception cause) {
        return cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName();
    }

    public static final class Builder {
        ActiveMQConnectionFactory connectionFactory;
        String queue = "zipkin";
        Encoding encoding = Encoding.JSON;
        int messageMaxBytes = 500000;

        public Builder connectionFactory(ActiveMQConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder queue(String queue) {
            if (queue == null) {
                throw new NullPointerException("queue == null");
            }
            this.queue = queue;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final ActiveMQSender build() {
            if (this.connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            return new ActiveMQSender(this);
        }

        Builder() {
        }
    }

    final class ActiveMQCall
    extends Call.Base<Void> {
        final byte[] message;

        ActiveMQCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            this.send();
            return null;
        }

        void send() throws IOException {
            try {
                ActiveMQConn conn = ActiveMQSender.this.lazyInit.get();
                QueueSender sender = conn.sender;
                BytesMessage bytesMessage = conn.session.createBytesMessage();
                bytesMessage.writeBytes(this.message);
                sender.send((Message)bytesMessage);
            }
            catch (JMSException e) {
                throw ActiveMQSender.ioException("Unable to send message: ", e);
            }
        }

        public Call<Void> clone() {
            return new ActiveMQCall(this.message);
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                this.send();
                callback.onSuccess(null);
            }
            catch (IOException | Error | RuntimeException e) {
                callback.onError(e);
            }
        }
    }
}

