/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.demo;

import eleme.openapi.sdk.api.entity.product.OCategory;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.api.service.ProductService;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.efs.EfsMediaClient;
import eleme.openapi.sdk.oauth.OAuthClient;
import eleme.openapi.sdk.oauth.impl.DefaultIOAuthClient;
import eleme.openapi.sdk.oauth.request.ClientTokenRequest;
import eleme.openapi.sdk.oauth.response.OpenId;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.utils.PropertiesUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class OAuthClientDemo {
    private static final boolean isSandbox = true;
    private static final String key = "app key";
    private static final String secret = "app secret";
    private static OAuthClient client = null;
    private static Map<String, String> tokenMap = new HashMap<String, String>();
    private static Config config = null;

    public static void main(String[] args) throws ServiceException {
        OAuthClientDemo demo = new OAuthClientDemo();
        demo.clientTokenChainSandBoxTest();
    }

    private void clientTokenTest() {
        Token token = client.getTokenInClientCredentials();
        if (token.isSuccess()) {
            OAuthClientDemo.setTokenInfo(token);
            System.out.println(token);
        } else {
            System.out.println("error_code: " + token.getError());
            System.out.println("error_desc: " + token.getError_description());
        }
    }

    private void clientTokenChainSandBoxTest() {
        config = new Config(true, true, "zDD7iCQ4E1", "671576abfeaaadf31d1ce11cd12fbfa89660");
        client = new OAuthClient(config);
        DefaultIOAuthClient ioAuthClient = new DefaultIOAuthClient(config, "token");
        ClientTokenRequest oAuthRequest = new ClientTokenRequest(config);
        Map<String, String> headMap = oAuthRequest.getHeaderMap();
        headMap.put("sand_box_chain_id", "92119012");
        oAuthRequest.setHeaderMap(headMap);
        Token token = ioAuthClient.execute(oAuthRequest);
        if (token.isSuccess()) {
            OAuthClientDemo.setTokenInfo(token);
            System.out.println(token);
        } else {
            System.out.println("error_code: " + token.getError());
            System.out.println("error_desc: " + token.getError_description());
        }
    }

    private void serverOAuthCodeTest() {
        String redirect_uri = "https://localhost:8899";
        String scope = "all";
        String state = "xyz";
        String authUrl = client.getAuthUrl(redirect_uri, scope, state);
        System.out.println(authUrl);
    }

    private void serverTokenTest() {
        String autoCode = "XXXXXXXXXXXX";
        String redirect_uri = "https://localhost:8899/demo";
        Token token = client.getTokenByCode(autoCode, redirect_uri);
        if (token.isSuccess()) {
            OAuthClientDemo.setTokenInfo(token);
            System.out.println(token);
        } else {
            System.out.println("error_code: " + token.getError());
            System.out.println("error_desc: " + token.getError_description());
        }
    }

    private void serverRefreshTokenTest() {
        String refreshTokenStr = "XXXXXXXXXXX";
        Token token = client.getTokenByRefreshToken(OAuthClientDemo.getToken().getRefreshToken());
        if (token.isSuccess()) {
            OAuthClientDemo.setTokenInfo(token);
            System.out.println(token);
        } else {
            System.out.println("error_code: " + token.getError());
            System.out.println("error_desc: " + token.getError_description());
        }
    }

    private void serverOpenIdTest() {
        String autoCode = "XXXXXXXXXXXX";
        String redirect_uri = "https://localhost:8899/demo";
        OpenId openId = client.getOpenIdByCode(autoCode, redirect_uri);
        if (openId.isSuccess()) {
            System.out.println(openId);
        } else {
            System.out.println("error_code: " + openId.getError());
            System.out.println("error_desc: " + openId.getError_description());
        }
    }

    private void testService() throws ServiceException {
        ProductService productService = new ProductService(config, OAuthClientDemo.getToken());
        OCategory category = productService.createCategory(987771L, "\u86cb\u7092\u996d", "\u4e00\u9053\u7f8e\u5473\u7684\u7092\u996d");
        System.out.println(category.getId());
    }

    private static Token getToken() {
        String access_token = PropertiesUtils.getPropValueByKey("access_token");
        String token_type = PropertiesUtils.getPropValueByKey("token_type");
        String expires_in = PropertiesUtils.getPropValueByKey("expires_in");
        String refresh_token = PropertiesUtils.getPropValueByKey("refresh_token");
        if (access_token.isEmpty()) {
            System.out.println("access_token is null");
            return null;
        }
        Token token = new Token();
        token.setAccessToken(access_token);
        token.setTokenType(token_type);
        token.setExpires(Long.valueOf(expires_in));
        token.setRefreshToken(refresh_token);
        return token;
    }

    private static void setTokenInfo(Token token) {
        if (null != token && token.isSuccess()) {
            tokenMap.put("access_token", token.getAccessToken());
            tokenMap.put("token_type", token.getTokenType());
            tokenMap.put("expires_in", String.valueOf(token.getExpires()));
            tokenMap.put("refresh_token", token.getRefreshToken());
            PropertiesUtils.setProps(tokenMap);
        }
    }

    private static void testVideoUpload(String token, File videoFile) {
        try {
            EfsMediaClient client = new EfsMediaClient(token);
            String videoId = client.uploadVideo(videoFile);
            System.out.println(videoId);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    static {
        config = new Config(true, key, secret);
        client = new OAuthClient(config);
    }
}

