/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.finance.AgentCommissionBillResponse;
import eleme.openapi.sdk.api.entity.finance.AllowanceBillDetails;
import eleme.openapi.sdk.api.entity.finance.AllowanceBills;
import eleme.openapi.sdk.api.entity.finance.BalanceResponse;
import eleme.openapi.sdk.api.entity.finance.BillsNew;
import eleme.openapi.sdk.api.entity.finance.BranchQuery;
import eleme.openapi.sdk.api.entity.finance.BranchShopBillPageQuery;
import eleme.openapi.sdk.api.entity.finance.FinanceGoodsOrders;
import eleme.openapi.sdk.api.entity.finance.FinanceOrdersNew;
import eleme.openapi.sdk.api.entity.finance.FundRelationsRequest;
import eleme.openapi.sdk.api.entity.finance.FundRelationsResponse;
import eleme.openapi.sdk.api.entity.finance.GenericCardBillsResponse;
import eleme.openapi.sdk.api.entity.finance.HeadQuery;
import eleme.openapi.sdk.api.entity.finance.HeadShopBillPageQuery;
import eleme.openapi.sdk.api.entity.finance.InsuranceBillResponse;
import eleme.openapi.sdk.api.entity.finance.ManualAccountBillResponse;
import eleme.openapi.sdk.api.entity.finance.OBalanceLogResponse;
import eleme.openapi.sdk.api.entity.finance.OQueryBalanceLogRequest;
import eleme.openapi.sdk.api.entity.finance.OrderBillQuery;
import eleme.openapi.sdk.api.entity.finance.PromotionBillResponse;
import eleme.openapi.sdk.api.entity.finance.RewardBillPageQuery;
import eleme.openapi.sdk.api.entity.finance.RewardBillQuery;
import eleme.openapi.sdk.api.entity.finance.RewardBillResult;
import eleme.openapi.sdk.api.entity.finance.TermAndNameQuery;
import eleme.openapi.sdk.api.entity.finance.TermAndNameResult;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.finance")
public class FinanceService
extends BaseNopService {
    public FinanceService(Config config, Token token) {
        super(config, token, FinanceService.class);
    }

    public BalanceResponse queryNewBalance(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (BalanceResponse)this.call("eleme.finance.queryNewBalance", params);
    }

    public BillsNew queryHeadBillsNew(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (BillsNew)this.call("eleme.finance.queryHeadBillsNew", params);
    }

    public BillsNew queryBranchBillsNew(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (BillsNew)this.call("eleme.finance.queryBranchBillsNew", params);
    }

    public AllowanceBillDetails queryAllowanceBillDetail(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (AllowanceBillDetails)this.call("eleme.finance.queryAllowanceBillDetail", params);
    }

    public TermAndNameResult queryTermAndName(TermAndNameQuery termAndNameQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("termAndNameQuery", termAndNameQuery);
        return (TermAndNameResult)this.call("eleme.finance.queryTermAndName", params);
    }

    public List<FundRelationsResponse> queryBySlave(FundRelationsRequest relationsRequest) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("relationsRequest", relationsRequest);
        return (List)this.call("eleme.finance.queryBySlave", params);
    }

    public List<Long> querySlaveShopIdsByChainId(Long chainId, Date checkoutDate) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("checkoutDate", checkoutDate);
        return (List)this.call("eleme.finance.querySlaveShopIdsByChainId", params);
    }

    public FinanceGoodsOrders queryGoodsOrders(Long settleAccountShopId, List<Long> shopIdList, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("settleAccountShopId", settleAccountShopId);
        params.put("shopIdList", shopIdList);
        params.put("query", query);
        return (FinanceGoodsOrders)this.call("eleme.finance.queryGoodsOrders", params);
    }

    public GenericCardBillsResponse queryHeadShopGenericCardBills(HeadShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (GenericCardBillsResponse)this.call("eleme.finance.queryHeadShopGenericCardBills", params);
    }

    public GenericCardBillsResponse queryBranchShopGenericCardBills(BranchShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (GenericCardBillsResponse)this.call("eleme.finance.queryBranchShopGenericCardBills", params);
    }

    public GenericCardBillsResponse queryGenericCardBillByOrder(OrderBillQuery orderBillQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderBillQuery", orderBillQuery);
        return (GenericCardBillsResponse)this.call("eleme.finance.queryGenericCardBillByOrder", params);
    }

    public RewardBillResult queryChainShopRewardBill(RewardBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (RewardBillResult)this.call("eleme.finance.queryChainShopRewardBill", params);
    }

    public RewardBillResult queryRewardBillByOrder(RewardBillQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        return (RewardBillResult)this.call("eleme.finance.queryRewardBillByOrder", params);
    }

    public PromotionBillResponse pageQueryChainShopPromotionBill(HeadShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (PromotionBillResponse)this.call("eleme.finance.pageQueryChainShopPromotionBill", params);
    }

    public PromotionBillResponse pageQueryBranchShopPromotionBill(BranchShopBillPageQuery branchShopBillPageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("branchShopBillPageQuery", branchShopBillPageQuery);
        return (PromotionBillResponse)this.call("eleme.finance.pageQueryBranchShopPromotionBill", params);
    }

    public PromotionBillResponse queryPromotionBillsByOrder(OrderBillQuery orderBillQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderBillQuery", orderBillQuery);
        return (PromotionBillResponse)this.call("eleme.finance.queryPromotionBillsByOrder", params);
    }

    public InsuranceBillResponse pageQueryChainShopInsuranceBills(HeadShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (InsuranceBillResponse)this.call("eleme.finance.pageQueryChainShopInsuranceBills", params);
    }

    public InsuranceBillResponse pageQueryBranchShopInsuranceBills(BranchShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (InsuranceBillResponse)this.call("eleme.finance.pageQueryBranchShopInsuranceBills", params);
    }

    public InsuranceBillResponse queryInsuranceBillsByOrder(OrderBillQuery orderBillQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderBillQuery", orderBillQuery);
        return (InsuranceBillResponse)this.call("eleme.finance.queryInsuranceBillsByOrder", params);
    }

    public AgentCommissionBillResponse pageQueryChainShopAgentCommissionBills(HeadShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (AgentCommissionBillResponse)this.call("eleme.finance.pageQueryChainShopAgentCommissionBills", params);
    }

    public AgentCommissionBillResponse pageQueryBranchShopAgentCommissionBills(BranchShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (AgentCommissionBillResponse)this.call("eleme.finance.pageQueryBranchShopAgentCommissionBills", params);
    }

    public AgentCommissionBillResponse queryAgentCommissionBillsByOrder(OrderBillQuery orderBillQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderBillQuery", orderBillQuery);
        return (AgentCommissionBillResponse)this.call("eleme.finance.queryAgentCommissionBillsByOrder", params);
    }

    public FinanceGoodsOrders queryBranchShopGoodsOrders(BranchShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (FinanceGoodsOrders)this.call("eleme.finance.queryBranchShopGoodsOrders", params);
    }

    public FinanceGoodsOrders pageQueryChainShopGoodsOrders(HeadShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (FinanceGoodsOrders)this.call("eleme.finance.pageQueryChainShopGoodsOrders", params);
    }

    public ManualAccountBillResponse pageQueryChainShopManualAccountBills(HeadShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (ManualAccountBillResponse)this.call("eleme.finance.pageQueryChainShopManualAccountBills", params);
    }

    public ManualAccountBillResponse pageQueryBranchShopManualAccountBills(BranchShopBillPageQuery pageQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageQuery", pageQuery);
        return (ManualAccountBillResponse)this.call("eleme.finance.pageQueryBranchShopManualAccountBills", params);
    }

    public AllowanceBills queryAllowanceBills(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (AllowanceBills)this.call("eleme.finance.queryAllowanceBills", params);
    }

    public OBalanceLogResponse queryBalanceLog(OQueryBalanceLogRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return (OBalanceLogResponse)this.call("eleme.finance.queryBalanceLog", params);
    }

    public FinanceOrdersNew queryBranchOrdersNew(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrdersNew)this.call("eleme.finance.queryBranchOrdersNew", params);
    }

    public FinanceOrdersNew queryHeadOrdersNew(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrdersNew)this.call("eleme.finance.queryHeadOrdersNew", params);
    }

    public FinanceOrdersNew getOrderNew(Long shopId, String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("orderId", orderId);
        return (FinanceOrdersNew)this.call("eleme.finance.getOrderNew", params);
    }
}

