/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.shop.BizResponse;
import eleme.openapi.sdk.api.entity.shop.DyCallBackEleDto;
import eleme.openapi.sdk.api.entity.shop.LicenseCheckDTO;
import eleme.openapi.sdk.api.entity.shop.LicenseDeviceInfo;
import eleme.openapi.sdk.api.entity.shop.OShop;
import eleme.openapi.sdk.api.entity.shop.OShopBusyLevelSetting;
import eleme.openapi.sdk.api.entity.shop.OSimpleShop;
import eleme.openapi.sdk.api.entity.shop.OVideoDeviceDTO;
import eleme.openapi.sdk.api.entity.shop.OpenStoreMessageBody;
import eleme.openapi.sdk.api.entity.shop.ProcessStatusResult;
import eleme.openapi.sdk.api.entity.shop.ProductInfoForPromotion;
import eleme.openapi.sdk.api.entity.shop.QueryLongLineAddressDTO;
import eleme.openapi.sdk.api.entity.shop.ShopAiRecognition;
import eleme.openapi.sdk.api.entity.shop.ShopLicenseInfo;
import eleme.openapi.sdk.api.entity.shop.ShopRecommendDeliveryTimeDto;
import eleme.openapi.sdk.api.entity.shop.SpecialDeliveryTimeDto;
import eleme.openapi.sdk.api.entity.shop.UpdateStoreMessageBody;
import eleme.openapi.sdk.api.enumeration.shop.OShopBasicProperty;
import eleme.openapi.sdk.api.enumeration.shop.OShopProperty;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(value="eleme.shop")
public class ShopService
extends BaseNopService {
    public ShopService(Config config, Token token) {
        super(config, token, ShopService.class);
    }

    public boolean dyCallBackForEle(DyCallBackEleDto ele_dto) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ele_dto", ele_dto);
        return (Boolean)this.call("eleme.shop.dyCallBackForEle", params);
    }

    public boolean dyUnBindShopForEle(String accountId, String merchantId, String version) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        params.put("merchantId", merchantId);
        params.put("version", version);
        return (Boolean)this.call("eleme.shop.dyUnBindShopForEle", params);
    }

    public boolean updateShopBasicInfo(long shopId, Map<OShopBasicProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("properties", properties);
        return (Boolean)this.call("eleme.shop.updateShopBasicInfo", params);
    }

    public Map<Long, OSimpleShop> mgetShopStatus(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (Map)this.call("eleme.shop.mgetShopStatus", params);
    }

    public void setDeliveryTime(long shopId, int deliveryBasicMins, int deliveryAdjustMins, List<SpecialDeliveryTimeDto> specialDeliveryTime, int distancePlusTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("deliveryBasicMins", deliveryBasicMins);
        params.put("deliveryAdjustMins", deliveryAdjustMins);
        params.put("specialDeliveryTime", specialDeliveryTime);
        params.put("distancePlusTime", distancePlusTime);
        this.call("eleme.shop.setDeliveryTime", params);
    }

    public void setSelfShopDeliveryTime(long shopId, Integer deliveryTime, List<SpecialDeliveryTimeDto> specialDeliveryTime, int distancePlusTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("deliveryTime", deliveryTime);
        params.put("specialDeliveryTime", specialDeliveryTime);
        params.put("distancePlusTime", distancePlusTime);
        this.call("eleme.shop.setSelfShopDeliveryTime", params);
    }

    public ShopRecommendDeliveryTimeDto getRecommendDeliveryTime(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (ShopRecommendDeliveryTimeDto)this.call("eleme.shop.getRecommendDeliveryTime", params);
    }

    public void setOnlineRefund(long shopId, boolean enable) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("enable", enable);
        this.call("eleme.shop.setOnlineRefund", params);
    }

    public void setBookingStatus(long shopId, boolean enabled, Integer maxBookingDays) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("enabled", enabled);
        params.put("maxBookingDays", maxBookingDays);
        this.call("eleme.shop.setBookingStatus", params);
    }

    public Map<Long, Long> getOidByShopIds(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (Map)this.call("eleme.shop.getOidByShopIds", params);
    }

    public void updateBusyLevelSetting(long shopId, Map<String, String> weekSetting, Map<String, String> dateSetting) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("weekSetting", weekSetting);
        params.put("dateSetting", dateSetting);
        this.call("eleme.shop.updateBusyLevelSetting", params);
    }

    public OShopBusyLevelSetting getBusyLevelSetting(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OShopBusyLevelSetting)this.call("eleme.shop.getBusyLevelSetting", params);
    }

    public void setBrandRankWeight(long shopId, double weight) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("weight", weight);
        this.call("eleme.shop.setBrandRankWeight", params);
    }

    public List<ProductInfoForPromotion> getProductSubsidyLimit(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.shop.getProductSubsidyLimit", params);
    }

    public void setShopTModel(long shopId, Integer deliveryTime, List<SpecialDeliveryTimeDto> specialDeliveryTime, int distancePlusTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("deliveryTime", deliveryTime);
        params.put("specialDeliveryTime", specialDeliveryTime);
        params.put("distancePlusTime", distancePlusTime);
        this.call("eleme.shop.setShopTModel", params);
    }

    public void setShopVocations(long shopId, List<String> vocationDates, Boolean enabled) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("vocationDates", vocationDates);
        params.put("enabled", enabled);
        this.call("eleme.shop.setShopVocations", params);
    }

    public List<String> getShopVocation(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.shop.getShopVocation", params);
    }

    public ShopLicenseInfo getShopLicense(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (ShopLicenseInfo)this.call("eleme.shop.getShopLicense", params);
    }

    public String getWssAddress(QueryLongLineAddressDTO queryLongLineAddressDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryLongLineAddressDTO", queryLongLineAddressDTO);
        return (String)this.call("eleme.shop.im.getWssAddress", params);
    }

    public Boolean getIMStatus(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (Boolean)this.call("eleme.shop.im.getIMStatus", params);
    }

    public Boolean updateIMStatus(Long shopId, Integer status) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("status", status);
        return (Boolean)this.call("eleme.shop.im.updateIMStatus", params);
    }

    public Long submitOpenStoreMessageAudit(OpenStoreMessageBody openStoreMessage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("openStoreMessage", openStoreMessage);
        return (Long)this.call("eleme.shop.setup.submitOpenStoreMessageAudit", params);
    }

    public Long submitOpenStoreForMermaid(OpenStoreMessageBody openStoreMessage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("openStoreMessage", openStoreMessage);
        return (Long)this.call("eleme.shop.setup.submitOpenStoreForMermaid", params);
    }

    public void updateOpenStoreMessageAudit(UpdateStoreMessageBody updateStoreMessageBody) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("updateStoreMessageBody", updateStoreMessageBody);
        this.call("eleme.shop.setup.updateOpenStoreMessageAudit", params);
    }

    public ProcessStatusResult queryProcessStatusBySubmitId(Long submitId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("submitId", submitId);
        return (ProcessStatusResult)this.call("eleme.shop.setup.queryProcessStatusBySubmitId", params);
    }

    public String uploadImage(String imageBase64) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageBase64", imageBase64);
        return (String)this.call("eleme.shop.setup.uploadImage", params);
    }

    public String uploadMinImage(String imageBase64) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageBase64", imageBase64);
        return (String)this.call("eleme.shop.setup.uploadMinImage", params);
    }

    public String uploadImageWithRemoteUrl(String url) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        return (String)this.call("eleme.shop.setup.uploadImageWithRemoteUrl", params);
    }

    public Boolean validateShopVideoStatus(String licenseNo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("licenseNo", licenseNo);
        return (Boolean)this.call("eleme.shop.video.validateShopVideoStatus", params);
    }

    public Boolean validateShopVideoStatusNew(LicenseCheckDTO licenseCheckDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("licenseCheckDTO", licenseCheckDTO);
        return (Boolean)this.call("eleme.shop.video.validateShopVideoStatusNew", params);
    }

    public BizResponse syncShopAiRecognitionResult(List<ShopAiRecognition> shopAiRecognition) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopAiRecognition", shopAiRecognition);
        return (BizResponse)this.call("eleme.shop.video.syncShopAiRecognitionResult", params);
    }

    public OShop updateShop(long shopId, Map<OShopProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("properties", properties);
        return (OShop)this.call("eleme.shop.updateShop", params);
    }

    public OShop getShop(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OShop)this.call("eleme.shop.getShop", params);
    }

    public Boolean syncShopVideoDevices(LicenseDeviceInfo licenseDeviceInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("licenseDeviceInfo", licenseDeviceInfo);
        return (Boolean)this.call("eleme.shop.video.syncShopVideoDevices", params);
    }

    public Boolean setVideoStatus(OVideoDeviceDTO videoDeviceDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("videoDeviceDTO", videoDeviceDTO);
        return (Boolean)this.call("eleme.shop.video.setVideoStatus", params);
    }
}

