/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.ugc.CouponDTO;
import eleme.openapi.sdk.api.entity.ugc.GiftCouponDTO;
import eleme.openapi.sdk.api.entity.ugc.OCouponExtendsDTO;
import eleme.openapi.sdk.api.entity.ugc.OCouponExtendsQuery;
import eleme.openapi.sdk.api.entity.ugc.ORateQuery;
import eleme.openapi.sdk.api.entity.ugc.ORateResult;
import eleme.openapi.sdk.api.entity.ugc.ORatingCouponDTO;
import eleme.openapi.sdk.api.entity.ugc.OUserRateQuery;
import eleme.openapi.sdk.api.entity.ugc.OpenapiItemRate;
import eleme.openapi.sdk.api.entity.ugc.OpenapiOrderRate;
import eleme.openapi.sdk.api.entity.ugc.OrderRateDetailDTO;
import eleme.openapi.sdk.api.entity.ugc.RecommendHistoriesCouponDTO;
import eleme.openapi.sdk.api.entity.ugc.ShopFactorInfo;
import eleme.openapi.sdk.api.enumeration.ugc.GiftCouponStatus;
import eleme.openapi.sdk.api.enumeration.ugc.ORateDataType;
import eleme.openapi.sdk.api.enumeration.ugc.ReplyType;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.ugc")
public class UgcService
extends BaseNopService {
    public UgcService(Config config, Token token) {
        super(config, token, UgcService.class);
    }

    public OpenapiOrderRate getOrderRateByOrderId(long orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OpenapiOrderRate)this.call("eleme.ugc.getOrderRateByOrderId", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (List)this.call("eleme.ugc.getOrderRatesByOrderIds", params);
    }

    public List<OpenapiOrderRate> getUnreplyOrderRatesByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (List)this.call("eleme.ugc.getUnreplyOrderRatesByOrderIds", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByShopId(String shopId, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getOrderRatesByShopId", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByShopIds(List<String> shopIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getOrderRatesByShopIds", params);
    }

    public List<OpenapiOrderRate> getUnreplyOrderRatesByShopIds(List<String> shopIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getUnreplyOrderRatesByShopIds", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByShopAndRating(String shopId, int score, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("score", score);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getOrderRatesByShopAndRating", params);
    }

    public List<OpenapiItemRate> getItemRatesByItemId(String itemId, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getItemRatesByItemId", params);
    }

    public List<OpenapiItemRate> getItemRatesByItemIds(List<String> itemIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getItemRatesByItemIds", params);
    }

    public List<OpenapiItemRate> getUnreplyItemRatesByItemIds(List<String> itemIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getUnreplyItemRatesByItemIds", params);
    }

    public void replyRateByOrderId(String orderId, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByOrderId", params);
    }

    public void replyCommentByOrderIds(List<String> orderIds, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        params.put("reply", reply);
        this.call("eleme.ugc.replyCommentByOrderIds", params);
    }

    public void replyRatesByItemId(String itemId, String reply, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("reply", reply);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        this.call("eleme.ugc.replyRatesByItemId", params);
    }

    public void replyRatesByItemIds(List<String> itemIds, String reply, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        params.put("reply", reply);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        this.call("eleme.ugc.replyRatesByItemIds", params);
    }

    public void replyRateByRateIdAndShopId(String rateId, String shopId, ReplyType replyType, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateId", rateId);
        params.put("shopId", shopId);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByRateIdAndShopId", params);
    }

    public void replyRateByRateIdsAndShopId(List<String> rateIds, String shopId, ReplyType replyType, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateIds", rateIds);
        params.put("shopId", shopId);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByRateIdsAndShopId", params);
    }

    public void replyRateByRateIdsAndShopIdV2(List<String> rateIds, String shopId, ReplyType replyType, String reply, Long templateId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateIds", rateIds);
        params.put("shopId", shopId);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        params.put("templateId", templateId);
        this.call("eleme.ugc.replyRateByRateIdsAndShopIdV2", params);
    }

    public void sendCouponByOrderId(String orderId, CouponDTO coupon) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("coupon", coupon);
        this.call("eleme.ugc.sendCouponByOrderId", params);
    }

    public GiftCouponStatus getOrderCouponStatus(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (GiftCouponStatus)((Object)this.call("eleme.ugc.getOrderCouponStatus", params));
    }

    public List<GiftCouponDTO> getCouponsByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (List)this.call("eleme.ugc.getCouponsByOrderIds", params);
    }

    public RecommendHistoriesCouponDTO getRecommendCouponByShopId(String shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (RecommendHistoriesCouponDTO)this.call("eleme.ugc.getRecommendCouponByShopId", params);
    }

    public ORateResult getORateResult(ORateQuery rateQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateQuery", rateQuery);
        return (ORateResult)this.call("eleme.ugc.getORateResult", params);
    }

    public ORateResult getOUserRateResult(OUserRateQuery rateQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateQuery", rateQuery);
        return (ORateResult)this.call("eleme.ugc.getOUserRateResult", params);
    }

    public long countORateResult(ORateQuery rateQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateQuery", rateQuery);
        return (Long)this.call("eleme.ugc.countORateResult", params);
    }

    public void replyBaiduRate(List<String> rateIds, String shopId, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateIds", rateIds);
        params.put("shopId", shopId);
        params.put("reply", reply);
        this.call("eleme.ugc.replyBaiduRate", params);
    }

    public void sendBaiduCoupon(String rateId, String shopId, CouponDTO coupon) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateId", rateId);
        params.put("shopId", shopId);
        params.put("coupon", coupon);
        this.call("eleme.ugc.sendBaiduCoupon", params);
    }

    public GiftCouponStatus getRateCouponStatus(String rateId, String shopId, ORateDataType rateDataType) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateId", rateId);
        params.put("shopId", shopId);
        params.put("rateDataType", (Object)rateDataType);
        return (GiftCouponStatus)((Object)this.call("eleme.ugc.getRateCouponStatus", params));
    }

    public void ratingCoupon(ORatingCouponDTO ratingCouponDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ratingCouponDTO", ratingCouponDTO);
        this.call("eleme.ugc.ratingCoupon", params);
    }

    public List<OCouponExtendsDTO> getCouponExtendsInfo(List<OCouponExtendsQuery> extendsQueries) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("extendsQueries", extendsQueries);
        return (List)this.call("eleme.ugc.getCouponExtendsInfo", params);
    }

    public List<ShopFactorInfo> getShopFactorInfos(Long supplierId, List<Long> shopIds, int offset, int limit) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("supplierId", supplierId);
        params.put("shopIds", shopIds);
        params.put("offset", offset);
        params.put("limit", limit);
        return (List)this.call("eleme.ugc.getShopFactorInfos", params);
    }

    public OrderRateDetailDTO getOrderRateDetail(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OrderRateDetailDTO)this.call("eleme.ugc.getOrderRateDetail", params);
    }

    public OpenapiOrderRate getOrderRateByOrderIdIncludeAnonymous(long orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OpenapiOrderRate)this.call("eleme.ugc.getOrderRateByOrderIdIncludeAnonymous", params);
    }
}

