/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.config;

import eleme.openapi.sdk.config.ElemeSdkLogger;
import eleme.openapi.sdk.utils.StringUtils;

public class Config {
    private String app_key;
    private String app_secret;
    private String oauthCodeUrl;
    private String serverUrl;
    private String apiUrl;
    private ElemeSdkLogger elemeSdkLogger;
    private boolean httpPoolRequest = true;

    public Config(boolean isSandbox, String appKey, String appSecret) {
        if (!StringUtils.areNotEmpty(appKey, appSecret)) {
            System.out.println("appKey and appSecret is required.");
        }
        this.app_key = appKey;
        this.app_secret = appSecret;
        if (isSandbox) {
            this.oauthCodeUrl = "https://open-api-sandbox.shop.ele.me/authorize";
            this.serverUrl = "https://open-api-sandbox.shop.ele.me/";
            this.apiUrl = "https://open-api-sandbox.shop.ele.me/api/v1/";
        } else {
            this.oauthCodeUrl = "https://open-api.shop.ele.me/authorize";
            this.serverUrl = "https://open-api.shop.ele.me/";
            this.apiUrl = "https://open-api.shop.ele.me/api/v1/";
        }
    }

    public Config(String appKey, boolean isPPE, String appSecret) {
        if (!StringUtils.areNotEmpty(appKey, appSecret)) {
            System.out.println("appKey and appSecret is required.");
        }
        this.app_key = appKey;
        this.app_secret = appSecret;
        this.oauthCodeUrl = "https://open-api.shop.ele.me/authorize";
        if (isPPE) {
            this.serverUrl = "https://ppe-open-api.shop.ele.me/";
            this.apiUrl = "https://ppe-open-api.shop.ele.me/api/v1/";
        } else {
            this.serverUrl = "https://open-api.ele.me/";
            this.apiUrl = "https://open-api.ele.me/api/v1/";
        }
    }

    public Config(boolean isCoupon, String appKey, boolean isSandbox, String appSecret) {
        if (!StringUtils.areNotEmpty(appKey, appSecret)) {
            System.out.println("appKey and appSecret is required.");
        }
        this.app_key = appKey;
        this.app_secret = appSecret;
        this.oauthCodeUrl = "https://open-api.shop.ele.me/authorize";
        if (isSandbox) {
            this.serverUrl = "https://open-api-sandbox.shop.ele.me/";
            this.apiUrl = "https://open-api-sandbox.shop.ele.me/api/v1/";
        } else {
            this.serverUrl = "https://open-api.shop.ele.me/";
            this.apiUrl = "https://open-api.shop.ele.me/api/coupon/v1/";
        }
    }

    public Config(boolean isSandbox, boolean isPPE, String appKey, String appSecret) {
        if (!StringUtils.areNotEmpty(appKey, appSecret)) {
            System.out.println("appKey and appSecret is required.");
        }
        this.app_key = appKey;
        this.app_secret = appSecret;
        if (isSandbox) {
            this.oauthCodeUrl = "https://open-api-sandbox.shop.ele.me/authorize";
            this.serverUrl = isPPE ? "https://ppe-open-api-sandbox.shop.ele.me/" : "https://open-api-sandbox.shop.ele.me/";
            this.apiUrl = "https://open-api-sandbox.shop.ele.me/api/v1/";
        } else {
            this.oauthCodeUrl = "https://open-api.shop.ele.me/authorize";
            if (isPPE) {
                this.serverUrl = "https://ppe-open-api.shop.ele.me/";
                this.apiUrl = "https://ppe-open-api.shop.ele.me/api/v1/";
            } else {
                this.serverUrl = "https://open-api.shop.ele.me/";
                this.apiUrl = "https://open-api.shop.ele.me/api/v1/";
            }
        }
    }

    public void setLog(ElemeSdkLogger elemeSdkLogger) {
        this.elemeSdkLogger = elemeSdkLogger;
    }

    public ElemeSdkLogger getElemeSdkLogger() {
        return this.elemeSdkLogger;
    }

    public void setOauthCodeUrl(String oauthCodeUrl) {
        this.oauthCodeUrl = oauthCodeUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getOauthCodeUrl() {
        return this.oauthCodeUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApp_key() {
        return this.app_key;
    }

    public String getApp_secret() {
        return this.app_secret;
    }

    public boolean isHttpPoolRequest() {
        return this.httpPoolRequest;
    }

    public void setHttpPoolRequest(boolean httpPoolRequest) {
        this.httpPoolRequest = httpPoolRequest;
    }
}

