/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.efs;

import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.media.Result;
import eleme.openapi.sdk.media.client.impl.DefaultMediaClient;
import eleme.openapi.sdk.media.upload.UploadRequest;
import eleme.openapi.sdk.media.upload.UploadResponse;
import eleme.openapi.sdk.utils.StringUtils;
import java.io.File;

public class EfsMediaClient {
    private static final Long VIDEO_MAX_LEN = 314572800L;
    private volatile DefaultMediaClient mediaClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMediaClient(String token) throws ServiceException {
        if (StringUtils.isEmpty(token)) {
            throw new ServiceException("GET_MEDIA_CLIENT_ERROR", "\u4e0a\u4f20token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.mediaClient == null) {
            EfsMediaClient efsMediaClient = this;
            synchronized (efsMediaClient) {
                if (this.mediaClient == null) {
                    this.mediaClient = new DefaultMediaClient(token);
                }
            }
        }
    }

    public EfsMediaClient(String token) throws ServiceException {
        this.init(token);
    }

    public void init(String token) throws ServiceException {
        this.getMediaClient(token);
    }

    public String uploadVideo(File videoFile) throws ServiceException {
        this.checkUploadReq(videoFile);
        UploadRequest request = new UploadRequest();
        request.setFile(videoFile);
        Result<UploadResponse> result2 = this.mediaClient.upload(request);
        if (result2 != null && result2.isSuccess()) {
            return result2.getData().getFileId();
        }
        throw new ServiceException("UPLOAD_VIDEO_ERROR", "\u4e0a\u4f20\u89c6\u9891\u5931\u8d25," + (result2 != null ? result2.getMessage() : ""));
    }

    public void checkUploadReq(File videoFile) throws ServiceException {
        if (this.mediaClient == null) {
            throw new ServiceException("GET_MEDIA_CLIENT", "\u8bf7\u5148\u521d\u59cb\u5316MediaClient\u5b9e\u4f8b");
        }
        if (videoFile == null || !videoFile.exists()) {
            throw new ServiceException("UPLOAD_VIDEO_ERROR", "\u4e0a\u4f20\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (videoFile.length() > VIDEO_MAX_LEN) {
            throw new ServiceException("UPLOAD_VIDEO_ERROR", "\u89c6\u9891\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7300M");
        }
    }
}

