/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.common;

import eleme.openapi.sdk.media.common.EncodeUtil;
import eleme.openapi.sdk.media.utils.IOUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.DateUtils;

public class AuthUtil {
    private static final String BLANK = " ";
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final String QUESTION = "?";
    private static final String LINEBREAK = "\n";
    private static final String URLENCODED_FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String TOP_AUTH_TYPE = "ACL_TOP";

    public static void authRequest(HttpRequestBase request, String ak, String sk, boolean compatible) throws IOException {
        String body = null;
        String date = DateUtils.formatDate((Date)new Date());
        request.setHeader("Date", date);
        if (request instanceof HttpEntityEnclosingRequestBase && ((HttpEntityEnclosingRequestBase)request).getEntity() != null) {
            HttpEntityEnclosingRequestBase entityRequest = (HttpEntityEnclosingRequestBase)request;
            Header[] contentTypeHeaders = request.getHeaders("Content-Type");
            if (contentTypeHeaders == null) {
                throw new IllegalArgumentException("Content-Type header required");
            }
            boolean isUrlFormEncoded = false;
            for (Header header : contentTypeHeaders) {
                if (!header.getValue().contains(URLENCODED_FORM_CONTENT_TYPE)) continue;
                isUrlFormEncoded = true;
                break;
            }
            if (entityRequest.getEntity().getContentType() != null && entityRequest.getEntity().getContentType().getValue() != null && entityRequest.getEntity().getContentType().getValue().contains(URLENCODED_FORM_CONTENT_TYPE)) {
                isUrlFormEncoded = true;
            }
            if (isUrlFormEncoded) {
                body = IOUtils.toString(entityRequest.getEntity().getContent());
            } else if (!compatible) {
                body = EncodeUtil.encodeWithMD5(entityRequest.getEntity().getContent(), 1024);
            }
        }
        if (request instanceof HttpEntityEnclosingRequestBase && ((HttpEntityEnclosingRequestBase)request).getEntity() == null) {
            throw new IllegalArgumentException("entity required");
        }
        request.setHeader("Authorization", AuthUtil.authHeader(request.getURI().getPath().toString(), request.getURI().getQuery(), body, date, ak, sk, TOP_AUTH_TYPE));
    }

    public static String authHeader(String uri, String queryString, String httpBody, String date, String ak, String sk, String authType) {
        String result2 = AuthUtil.authHeader(AuthUtil.headerBeforeEncode(uri, queryString, httpBody, date, ak, sk), authType);
        return result2;
    }

    public static String sign(String stringBeforeSign, String sk) {
        AuthUtil.checkNotNull(sk);
        AuthUtil.checkNotNull(stringBeforeSign);
        try {
            String result2 = EncodeUtil.encodeWithHmacSha1(stringBeforeSign, sk);
            return result2;
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    public static String sign(String uri, String queryString, String httpBody, String date, String sk) {
        return AuthUtil.sign(AuthUtil.stringBeforeSign(uri, queryString, httpBody, date), sk);
    }

    public static String stringBeforeSign(String uri, String queryString, String httpBody, String date) {
        AuthUtil.checkArgument(AuthUtil.isNotBlank(uri));
        AuthUtil.checkNotNull(date);
        StringBuffer sb = new StringBuffer(EMPTY);
        sb.append(uri);
        if (AuthUtil.isNotBlank(queryString)) {
            sb.append(QUESTION).append(queryString);
        }
        sb.append(LINEBREAK);
        if (AuthUtil.isNotBlank(httpBody)) {
            sb.append(httpBody);
        }
        sb.append(LINEBREAK);
        sb.append(date);
        return sb.toString();
    }

    private static String authHeader(String headerBeforeEncode, String type) {
        AuthUtil.checkNotNull(type);
        AuthUtil.checkNotNull(headerBeforeEncode);
        String headerAfterEncode = EncodeUtil.encodeWithURLSafeBase64(headerBeforeEncode);
        return type + BLANK + headerAfterEncode;
    }

    private static String headerBeforeEncode(String uri, String queryString, String httpBody, String date, String ak, String sk) {
        AuthUtil.checkNotNull(ak);
        AuthUtil.checkNotNull(sk);
        return ak + COLON + AuthUtil.sign(uri, queryString, httpBody, date, sk);
    }

    private static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private static boolean isNotBlank(CharSequence cs) {
        return !AuthUtil.isBlank(cs);
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

