/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.common.http;

import eleme.openapi.sdk.media.MediaConfiguration;
import eleme.openapi.sdk.media.Result;
import eleme.openapi.sdk.media.trace.Code;
import eleme.openapi.sdk.media.trace.Reporter;
import eleme.openapi.sdk.media.upload.BaseUploadRequest;
import eleme.openapi.sdk.media.upload.MultipartCancelRequest;
import eleme.openapi.sdk.media.upload.MultipartCompleteRequest;
import eleme.openapi.sdk.media.upload.MultipartInitRequest;
import eleme.openapi.sdk.media.upload.MultipartUploadRequest;
import eleme.openapi.sdk.media.upload.UploadRequest;
import eleme.openapi.sdk.utils.JacksonUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public abstract class HttpClientBase {
    private static HttpClient httpClient;
    public static boolean keepAlive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpClient getHttpClient() {
        if (httpClient == null) {
            HttpClientBase httpClientBase = this;
            synchronized (httpClientBase) {
                if (httpClient == null) {
                    httpClient = HttpClientBuilder.create().setMaxConnTotal(MediaConfiguration.MAX_HTTP_CONNECTIONS).setMaxConnPerRoute(MediaConfiguration.MAX_HTTP_CONNECTIONS).disableAutomaticRetries().build();
                }
            }
        }
        return httpClient;
    }

    protected <T> Result<T> executeWithUploadTrace(HttpRequestBase request, BaseUploadRequest baseUploadRequest, Class<T> clazz, Reporter.OP op, long uploadSize) {
        Reporter.sharedInstance().start();
        Reporter.sharedInstance().enter(op);
        String uploadId = Reporter.sharedInstance().getSessionId();
        request.setHeader("X-Media-Session-Id", uploadId);
        Reporter.sharedInstance().addKV("uploadStartTime", String.valueOf(System.currentTimeMillis()));
        Result<T> result2 = this.execute(request, clazz);
        String code = result2.getT() != null ? Code.LOCAL_ERROR.value : Code.REMOTE_PREFIX.value + result2.getHttpStatus();
        String message = result2.getT() != null ? result2.getT().getMessage() : result2.getMessage();
        message = message != null ? message.replaceAll(";", "") : null;
        Reporter.sharedInstance().release(op);
        if (baseUploadRequest != null) {
            BaseUploadRequest req;
            if (baseUploadRequest.getUploadPolicy() != null) {
                Reporter.sharedInstance().addKV("namespace", baseUploadRequest.getUploadPolicy().getNamespace());
                Reporter.sharedInstance().addKV("policyName", baseUploadRequest.getUploadPolicy().getName());
                Reporter.sharedInstance().addKV("policyDir", baseUploadRequest.getUploadPolicy().getDir());
            }
            if (baseUploadRequest instanceof MultipartCancelRequest) {
                req = (MultipartCancelRequest)baseUploadRequest;
                Reporter.sharedInstance().addKV("multipartId", ((MultipartCancelRequest)req).getId());
                Reporter.sharedInstance().addKV("multipartUploadId", ((MultipartCancelRequest)req).getUploadId());
                Reporter.sharedInstance().addKV("dir", ((MultipartCancelRequest)req).getDir());
                Reporter.sharedInstance().addKV("name", ((MultipartCancelRequest)req).getName());
            }
            if (baseUploadRequest instanceof MultipartCompleteRequest) {
                req = (MultipartCompleteRequest)baseUploadRequest;
                Reporter.sharedInstance().addKV("multipartId", ((MultipartCompleteRequest)req).getId());
                Reporter.sharedInstance().addKV("multipartUploadId", ((MultipartCompleteRequest)req).getUploadId());
                Reporter.sharedInstance().addKV("dir", ((MultipartCompleteRequest)req).getDir());
                Reporter.sharedInstance().addKV("name", ((MultipartCompleteRequest)req).getName());
            }
            if (baseUploadRequest instanceof MultipartInitRequest) {
                req = (MultipartInitRequest)baseUploadRequest;
                Reporter.sharedInstance().addKV("dir", ((MultipartInitRequest)req).getDir());
                Reporter.sharedInstance().addKV("name", ((MultipartInitRequest)req).getName());
            }
            if (baseUploadRequest instanceof MultipartUploadRequest) {
                req = (MultipartUploadRequest)baseUploadRequest;
                Reporter.sharedInstance().addKV("dir", ((MultipartUploadRequest)req).getDir());
                Reporter.sharedInstance().addKV("multipartId", ((MultipartUploadRequest)req).getId());
                Reporter.sharedInstance().addKV("multipartUploadId", ((MultipartUploadRequest)req).getUploadId());
                Reporter.sharedInstance().addKV("name", ((MultipartUploadRequest)req).getName());
            }
            if (baseUploadRequest instanceof UploadRequest) {
                req = (UploadRequest)baseUploadRequest;
                Reporter.sharedInstance().addKV("dir", ((UploadRequest)req).getDir());
                Reporter.sharedInstance().addKV("name", ((UploadRequest)req).getName());
            }
        }
        Reporter.sharedInstance().finish(result2.getRequestId(), uploadId, message, code, uploadSize);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Result<T> execute(HttpRequestBase request, final Class<T> clazz) {
        HttpClient httpClient = this.getHttpClient();
        if (!keepAlive) {
            request.setHeader("Connection", "close");
        }
        ResponseHandler handler = new ResponseHandler<Result<T>>(){

            public Result<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                String body;
                int status = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                String string = body = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                if (status >= 200 && status < 300) {
                    if (clazz != null && clazz != Void.class) {
                        return Result.create(status, JacksonUtils.json2pojo(body, clazz), HttpClientBase.this.getRequestIdQuietly(body));
                    }
                    return Result.create(status, null, HttpClientBase.this.getRequestIdQuietly(body));
                }
                Map<String, Object> info = JacksonUtils.json2map(body);
                String requestId = HttpClientBase.this.getValue(info, "requestId");
                String code = HttpClientBase.this.getValue(info, "code");
                String msg = HttpClientBase.this.getValue(info, "message");
                if (msg == null) {
                    msg = HttpClientBase.this.getValue(info, "msg");
                }
                return Result.create(status, requestId, code, msg);
            }
        };
        try {
            Result result2 = (Result)httpClient.execute((HttpUriRequest)request, handler);
            return result2;
        }
        catch (Exception e) {
            Result result3 = Result.create(0, null, "ClientError", e.getMessage());
            result3.setT(e);
            Result result4 = result3;
            return result4;
        }
        finally {
            try {
                request.releaseConnection();
            }
            catch (Exception exception) {}
        }
    }

    private String getRequestIdQuietly(String json) {
        try {
            return String.valueOf(JacksonUtils.json2map(json).get("requestId"));
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String getValue(Map<String, Object> kvs, String key) {
        return kvs != null && kvs.containsKey(key) ? String.valueOf(kvs.get(key)) : null;
    }

    static {
        keepAlive = true;
    }
}

