/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.trace;

import eleme.openapi.sdk.media.MediaConfiguration;
import eleme.openapi.sdk.media.Result;
import eleme.openapi.sdk.media.common.AuthUtil;
import eleme.openapi.sdk.media.common.http.HttpClientBase;
import eleme.openapi.sdk.media.utils.CompressUtils;
import eleme.openapi.sdk.media.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class ReportClient
extends HttpClientBase {
    private static final String TRACE_URI = "/3.0/trace";
    private static byte[] LINE_BREAK;

    public void report(List<String> reports) {
        byte[] rawBody;
        MediaConfiguration configuration = MediaConfiguration.getLastConfiguration();
        if (configuration == null || configuration.getAk() == null || configuration.getSk() == null) {
            throw new RuntimeException("no configuration");
        }
        HttpPost post = new HttpPost(MediaConfiguration.DATA_ENDPOINT + TRACE_URI);
        byte[] body = rawBody = this.getRawBodyOfString(reports);
        if (rawBody == null) {
            return;
        }
        boolean isGzip = false;
        if (rawBody.length > 1024) {
            isGzip = true;
            body = CompressUtils.compress(rawBody);
            body = body == null ? rawBody : body;
        }
        post.setHeader("Content-Type", "application/octet-stream");
        if (isGzip) {
            post.setHeader("Content-Encoding", "gzip");
        }
        post.setEntity(EntityBuilder.create().setBinary(body).build());
        try {
            AuthUtil.authRequest((HttpRequestBase)post, configuration.getAk(), configuration.getSk(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        Result<Void> result2 = this.execute((HttpRequestBase)post, Void.class);
        if (!result2.isSuccess()) {
            throw new RuntimeException(result2.getHttpStatus() + ":" + result2.getCode() + ":" + result2.getMessage() + ":" + result2.getRequestId(), result2.getT());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getRawBodyOfString(List<String> reports) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            for (String report : reports) {
                out.write(report.getBytes("utf-8"));
                out.write(LINE_BREAK);
            }
            Object object = out.toByteArray();
            return object;
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return null;
    }

    static {
        try {
            LINE_BREAK = "\n".getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

