/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.upload.impl;

import eleme.openapi.sdk.media.MediaConfiguration;
import eleme.openapi.sdk.media.Result;
import eleme.openapi.sdk.media.common.EncodeUtil;
import eleme.openapi.sdk.media.common.http.HttpClientBase;
import eleme.openapi.sdk.media.common.http.LengthInputStreamBody;
import eleme.openapi.sdk.media.trace.Reporter;
import eleme.openapi.sdk.media.upload.MultipartCancelRequest;
import eleme.openapi.sdk.media.upload.MultipartCompleteRequest;
import eleme.openapi.sdk.media.upload.MultipartCompleteResponse;
import eleme.openapi.sdk.media.upload.MultipartInitRequest;
import eleme.openapi.sdk.media.upload.MultipartInitResponse;
import eleme.openapi.sdk.media.upload.MultipartUploadRequest;
import eleme.openapi.sdk.media.upload.MultipartUploadResponse;
import eleme.openapi.sdk.media.upload.UploadClient;
import eleme.openapi.sdk.media.upload.UploadRequest;
import eleme.openapi.sdk.media.upload.UploadResponse;
import eleme.openapi.sdk.utils.JacksonUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;

public class DefaultUploadClient
extends HttpClientBase
implements UploadClient {
    private static final ContentType DEFAULT_TEXT = ContentType.create((String)"text/plain", (String)MediaConfiguration.CHARSET);
    private static final ContentType DEFAULT_BINARY = ContentType.DEFAULT_BINARY;
    private String endPoint = MediaConfiguration.UPLOAD_ENDPOINT;

    public DefaultUploadClient(String endPoint) {
        this.endPoint = endPoint;
    }

    public DefaultUploadClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<UploadResponse> upload(UploadRequest req) {
        if (!(req.getInputStream() != null || req.getFile() != null && req.getFile().isFile())) {
            throw new IllegalArgumentException("content is invalid.");
        }
        InputStream input = this.getInputStream(req);
        long length = this.getInputStreamLength(req);
        try {
            HttpPost post = new HttpPost(this.getApiUrl(MediaConfiguration.UPLOAD_API_UPLOAD));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            this.text("dir", req.getDir(), builder);
            this.text("name", req.getName(), builder);
            this.text("md5", req.getMd5(), builder);
            this.text("size", length, builder);
            this.text("localFileName", req.getLocalFileName(), builder);
            this.metavars("meta", req.getMetas(), builder);
            this.metavars("var", req.getVars(), builder);
            this.addParameters(req.getExtendPars(), builder);
            this.inputstream("content", input, length, builder);
            post.setHeader("Authorization", req.getToken());
            post.setHeader("User-Agent", this.getUserAgent(req.getToken()));
            post.setEntity(builder.build());
            Result<UploadResponse> result2 = this.executeWithUploadTrace((HttpRequestBase)post, req, UploadResponse.class, Reporter.OP.UPLOAD, length);
            return result2;
        }
        finally {
            if (req.getFile() != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Result<MultipartInitResponse> multipartInit(MultipartInitRequest req) {
        HttpPost post = new HttpPost(this.getApiUrl(MediaConfiguration.UPLOAD_API_BLOCK_INIT));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        this.text("dir", req.getDir(), builder);
        this.text("name", req.getName(), builder);
        this.text("md5", req.getMd5(), builder);
        this.text("localFileName", req.getLocalFileName(), builder);
        this.metavars("meta", req.getMetas(), builder);
        this.metavars("var", req.getVars(), builder);
        this.addParameters(req.getExtendPars(), builder);
        if (req.getContent() != null) {
            this.text("size", req.getContentSize(), builder);
            this.inputstream("content", req.getContent(), req.getContentSize(), builder);
        }
        post.setHeader("Authorization", req.getToken());
        post.setHeader("User-Agent", this.getUserAgent(req.getToken()));
        post.setEntity(builder.build());
        return this.executeWithUploadTrace((HttpRequestBase)post, req, MultipartInitResponse.class, Reporter.OP.BLOCK_INIT, req.getContentSize());
    }

    @Override
    public Result<MultipartUploadResponse> multipartUpload(MultipartUploadRequest req) {
        HttpPost post = new HttpPost(this.getApiUrl(MediaConfiguration.UPLOAD_API_BLOCK_UPLOAD));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        this.text("dir", req.getDir(), builder);
        this.text("name", req.getName(), builder);
        this.text("md5", req.getMd5(), builder);
        this.text("size", req.getContentSize(), builder);
        this.text("id", req.getId(), builder);
        this.text("uploadId", req.getUploadId(), builder);
        this.text("partNumber", req.getPartNumber(), builder);
        this.metavars("meta", req.getMetas(), builder);
        this.metavars("var", req.getVars(), builder);
        this.addParameters(req.getExtendPars(), builder);
        this.inputstream("content", req.getContent(), req.getContentSize(), builder);
        post.setHeader("Authorization", req.getToken());
        post.setHeader("User-Agent", this.getUserAgent(req.getToken()));
        post.setEntity(builder.build());
        return this.executeWithUploadTrace((HttpRequestBase)post, req, MultipartUploadResponse.class, Reporter.OP.BLOCK_UPLOAD, req.getContentSize());
    }

    @Override
    public Result<MultipartCompleteResponse> multipartComplete(MultipartCompleteRequest req) {
        HttpPost post = new HttpPost(this.getApiUrl(MediaConfiguration.UPLOAD_API_BLOCK_COMPLETE));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        this.text("dir", req.getDir(), builder);
        this.text("name", req.getName(), builder);
        this.text("md5", req.getMd5(), builder);
        this.text("id", req.getId(), builder);
        this.text("uploadId", req.getUploadId(), builder);
        this.metavars("meta", req.getMetas(), builder);
        this.metavars("var", req.getVars(), builder);
        this.addParameters(req.getExtendPars(), builder);
        this.text("parts", EncodeUtil.encodeWithURLSafeBase64(JacksonUtils.obj2json(req.getParts())), builder);
        post.setHeader("Authorization", req.getToken());
        post.setHeader("User-Agent", this.getUserAgent(req.getToken()));
        post.setEntity(builder.build());
        return this.executeWithUploadTrace((HttpRequestBase)post, req, MultipartCompleteResponse.class, Reporter.OP.BLOCK_COMPLETE, 0L);
    }

    @Override
    public Result<Void> multipartCancel(MultipartCancelRequest req) {
        HttpPost post = new HttpPost(this.getApiUrl(MediaConfiguration.UPLOAD_API_BLOCK_CANCEL));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        this.text("dir", req.getDir(), builder);
        this.text("name", req.getName(), builder);
        this.text("id", req.getId(), builder);
        this.text("uploadId", req.getUploadId(), builder);
        post.setHeader("Authorization", req.getToken());
        post.setHeader("User-Agent", this.getUserAgent(req.getToken()));
        post.setEntity(builder.build());
        return this.executeWithUploadTrace((HttpRequestBase)post, req, null, Reporter.OP.BLOCK_CANCEL, 0L);
    }

    @Override
    public void setTraceOn(boolean traceOn) {
        Reporter.sharedInstance().setTraceOn(traceOn);
    }

    private void text(String name, Object value, MultipartEntityBuilder builder) {
        if (value != null) {
            builder.addTextBody(name, String.valueOf(value), DEFAULT_TEXT);
        }
    }

    private void inputstream(String name, InputStream in, long contentLength, MultipartEntityBuilder builder) {
        builder.addPart(name, (ContentBody)new LengthInputStreamBody(in, DEFAULT_BINARY, name, contentLength));
    }

    private void metavars(String prefix, Map<String, String> kvs, MultipartEntityBuilder builder) {
        if (kvs != null && !kvs.isEmpty()) {
            for (Map.Entry<String, String> kv : kvs.entrySet()) {
                builder.addTextBody(prefix + "-" + kv.getKey(), kv.getValue(), DEFAULT_TEXT);
            }
        }
    }

    private void addParameters(Map<String, Object> kvs, MultipartEntityBuilder builder) {
        if (kvs != null && !kvs.isEmpty()) {
            for (Map.Entry<String, Object> kv : kvs.entrySet()) {
                builder.addTextBody(kv.getKey(), kv.getValue().toString(), DEFAULT_TEXT);
            }
        }
    }

    private InputStream getInputStream(UploadRequest req) {
        try {
            return req.getFile() != null ? new FileInputStream(req.getFile()) : req.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    private long getInputStreamLength(UploadRequest req) {
        return req.getFile() != null ? req.getFile().length() : req.getInputLength();
    }

    private String getUserAgent(String token) {
        if (token.startsWith("UPLOAD_AK_TOP")) {
            return "ALIMEDIASDK_JAVA_ELE/" + MediaConfiguration.SDK_VERSION;
        }
        return "ALIMEDIASDK_JAVA_CLOUD/" + MediaConfiguration.SDK_VERSION;
    }

    protected String getApiUrl(String api) {
        return this.getEndPoint() + api;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }
}

