/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class IpUtils {
    static String LOCAL_IP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String getIpAddress() {
        if (LOCAL_IP != null) return LOCAL_IP;
        Class<IpUtils> clazz = IpUtils.class;
        synchronized (IpUtils.class) {
            if (LOCAL_IP != null) return LOCAL_IP;
            LOCAL_IP = IpUtils.getIpAddressInternal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return LOCAL_IP;
        }
    }

    private static final String getIpAddressInternal() {
        Enumeration<NetworkInterface> netInterfaces;
        String localip = null;
        String netip = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException("Can't find the localIP!");
        }
        boolean finded = false;
        block4: while (netInterfaces.hasMoreElements() && !finded) {
            NetworkInterface ni = netInterfaces.nextElement();
            try {
                if (ni.isLoopback()) continue;
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    InetAddress ip = address.nextElement();
                    if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block4;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                    localip = ip.getHostAddress();
                }
            }
            catch (SocketException socketException) {
            }
        }
        if (localip != null && !"".equals(localip)) {
            return localip;
        }
        return netip;
    }
}

