/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.oauth.impl;

import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.IOAuthClient;
import eleme.openapi.sdk.oauth.OAuthRequest;
import eleme.openapi.sdk.oauth.response.ErrorResponse;
import eleme.openapi.sdk.utils.JacksonUtils;
import eleme.openapi.sdk.utils.WebUtils;
import java.io.IOException;

public class DefaultIOAuthClient
implements IOAuthClient {
    private int connectTimeout = 15000;
    private int readTimeout = 30000;
    private String serverHostUrl;
    private Config context;

    public DefaultIOAuthClient(Config context, String suffix) {
        this.context = context;
        this.serverHostUrl = context.getServerUrl() + suffix;
    }

    @Override
    public <T extends ErrorResponse> T execute(OAuthRequest<T> request) {
        try {
            String respJson = WebUtils.doPost(this.context, this.serverHostUrl, request.getBodyMap(), "UTF-8", WebUtils.getReqID(), this.connectTimeout, this.readTimeout, request.getHeaderMap());
            return (T)((ErrorResponse)JacksonUtils.json2pojo(respJson, request.getResponseClass()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

