/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.oceanbase.database.dialect;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialectConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class OceanBaseDialectConverter
extends AbstractDialectConverter {
    private static final long serialVersionUID = 1L;

    public String converterName() {
        return "OceanBase";
    }

    public OceanBaseDialectConverter(RowType rowType) {
        super(rowType);
    }

    public AbstractDialectConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? ((Number)val).intValue() == 1 : Boolean.parseBoolean(val.toString());
            }
            case FLOAT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? Float.valueOf(((Number)val).floatValue()) : val;
            }
            case DOUBLE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? Double.valueOf(((Number)val).doubleValue()) : val;
            }
            case TINYINT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? Byte.valueOf(((Number)val).byteValue()) : val;
            }
            case SMALLINT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? Short.valueOf(((Number)val).shortValue()) : val;
            }
            case INTEGER: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? Integer.valueOf(((Number)val).intValue()) : (val instanceof Date ? Integer.valueOf(((Date)val).toLocalDate().getYear()) : val);
            }
            case BIGINT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Number ? Long.valueOf(((Number)val).longValue()) : val;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val, 0), (int)precision, (int)scale) : (val instanceof BigDecimal ? DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(val.toString()), (int)precision, (int)scale));
            }
            case DATE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Date ? Integer.valueOf((int)((Date)val).toLocalDate().toEpochDay()) : (val instanceof Timestamp ? Integer.valueOf((int)((Timestamp)val).toLocalDateTime().toLocalDate().toEpochDay()) : val);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Time ? Integer.valueOf((int)(((Time)val).toLocalTime().toNanoOfDay() / 1000000L)) : (val instanceof Timestamp ? Integer.valueOf((int)(((Timestamp)val).toLocalDateTime().toLocalTime().toNanoOfDay() / 1000000L)) : val);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof LocalDateTime ? TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)val)) : (val instanceof Timestamp ? TimestampData.fromTimestamp((Timestamp)((Timestamp)val)) : val);
            }
            case CHAR: 
            case VARCHAR: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> StringData.fromString((String)val.toString());
            }
            case BINARY: 
            case VARBINARY: 
            case RAW: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof Blob ? (Object)((Blob)val).getBytes(1L, (int)((Blob)val).length()) : (val instanceof byte[] ? val : (Object)val.toString().getBytes());
            }
        }
        return super.createInternalConverter(type);
    }
}

