/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.postgres.database.dialect;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.postgres.database.dialect.PostgresDialectConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class PostgresDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 6;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 1000;
    private static final int MIN_DECIMAL_PRECISION = 1;

    public PostgresDialectConverter getRowConverter(RowType rowType) {
        return new PostgresDialectConverter(rowType);
    }

    public Optional<String> defaultDriverName() {
        return Optional.of("org.postgresql.Driver");
    }

    public String dialectName() {
        return "PostgreSQL";
    }

    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String uniqueColumns = Arrays.stream(uniqueKeyFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        HashSet<String> uniqueKeyFieldsSet = new HashSet<String>(Arrays.asList(uniqueKeyFields));
        String updateClause = Arrays.stream(fieldNames).filter(f -> !uniqueKeyFieldsSet.contains(f)).map(f -> this.quoteIdentifier((String)f) + "=EXCLUDED." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String conflictAction = updateClause.isEmpty() ? " DO NOTHING" : String.format(" DO UPDATE SET %s", updateClause);
        return Optional.of(this.getInsertIntoStatement(tableName, fieldNames) + " ON CONFLICT (" + uniqueColumns + ")" + conflictAction);
    }

    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)1000));
    }

    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)6));
    }

    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.ARRAY});
    }
}

