/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.jdbc.JdbcExactlyOnceOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.core.datastream.sink.JdbcSinkBuilder;
import org.apache.flink.connector.jdbc.core.datastream.sink.committer.JdbcCommitable;
import org.apache.flink.connector.jdbc.core.datastream.sink.committer.JdbcCommitableSerializer;
import org.apache.flink.connector.jdbc.core.datastream.sink.committer.JdbcCommitter;
import org.apache.flink.connector.jdbc.core.datastream.sink.writer.JdbcWriter;
import org.apache.flink.connector.jdbc.core.datastream.sink.writer.JdbcWriterState;
import org.apache.flink.connector.jdbc.core.datastream.sink.writer.JdbcWriterStateSerializer;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.statements.JdbcQueryStatement;
import org.apache.flink.connector.jdbc.internal.JdbcOutputSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;

@PublicEvolving
public class JdbcSink<IN>
implements StatefulSink<IN, JdbcWriterState>,
TwoPhaseCommittingSink<IN, JdbcCommitable> {
    private final DeliveryGuarantee deliveryGuarantee;
    private final JdbcConnectionProvider connectionProvider;
    private final JdbcExecutionOptions executionOptions;
    private final JdbcExactlyOnceOptions exactlyOnceOptions;
    private final JdbcQueryStatement<IN> queryStatement;

    public JdbcSink(DeliveryGuarantee deliveryGuarantee, JdbcConnectionProvider connectionProvider, JdbcExecutionOptions executionOptions, JdbcExactlyOnceOptions exactlyOnceOptions, JdbcQueryStatement<IN> queryStatement) {
        this.deliveryGuarantee = deliveryGuarantee;
        this.connectionProvider = connectionProvider;
        this.executionOptions = executionOptions;
        this.exactlyOnceOptions = exactlyOnceOptions;
        this.queryStatement = queryStatement;
    }

    public static <IN> JdbcSinkBuilder<IN> builder() {
        return new JdbcSinkBuilder();
    }

    @Internal
    public JdbcWriter<IN> createWriter(Sink.InitContext context) throws IOException {
        return this.restoreWriter(context, (Collection)Collections.emptyList());
    }

    @Internal
    public JdbcWriter<IN> restoreWriter(Sink.InitContext context, Collection<JdbcWriterState> recoveredState) throws IOException {
        JdbcOutputSerializer outputSerializer = JdbcOutputSerializer.of(context.createInputSerializer(), context.isObjectReuseEnabled());
        return new JdbcWriter<IN>(this.connectionProvider, this.executionOptions, this.exactlyOnceOptions, this.queryStatement, outputSerializer, this.deliveryGuarantee, recoveredState, context);
    }

    @Internal
    public Committer<JdbcCommitable> createCommitter() throws IOException {
        return new JdbcCommitter(this.deliveryGuarantee, this.connectionProvider, this.exactlyOnceOptions);
    }

    @Internal
    public SimpleVersionedSerializer<JdbcCommitable> getCommittableSerializer() {
        return new JdbcCommitableSerializer();
    }

    @Internal
    public SimpleVersionedSerializer<JdbcWriterState> getWriterStateSerializer() {
        return new JdbcWriterStateSerializer();
    }
}

