/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.sink.writer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.jdbc.JdbcExactlyOnceOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.core.datastream.sink.committer.JdbcCommitable;
import org.apache.flink.connector.jdbc.core.datastream.sink.writer.JdbcWriterState;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.xa.XaConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.statements.JdbcQueryStatement;
import org.apache.flink.connector.jdbc.datasource.transactions.xa.XaTransaction;
import org.apache.flink.connector.jdbc.datasource.transactions.xa.domain.TransactionId;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.JdbcOutputSerializer;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcWriter<IN>
implements StatefulSink.StatefulSinkWriter<IN, JdbcWriterState>,
TwoPhaseCommittingSink.PrecommittingSinkWriter<IN, JdbcCommitable> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcWriter.class);
    private final DeliveryGuarantee deliveryGuarantee;
    private final JdbcOutputFormat<IN, IN, JdbcBatchStatementExecutor<IN>> jdbcOutput;
    private XaTransaction jdbcTransaction;
    private long lastCheckpointId;
    private boolean pendingRecords;

    public JdbcWriter(JdbcConnectionProvider connectionProvider, JdbcExecutionOptions executionOptions, JdbcExactlyOnceOptions exactlyOnceOptions, JdbcQueryStatement<IN> queryStatement, JdbcOutputSerializer<IN> outputSerializer, DeliveryGuarantee deliveryGuarantee, Collection<JdbcWriterState> recoveredState, Sink.InitContext initContext) throws IOException {
        this.deliveryGuarantee = (DeliveryGuarantee)Preconditions.checkNotNull((Object)deliveryGuarantee, (String)"deliveryGuarantee must be defined");
        Preconditions.checkNotNull((Object)initContext, (String)"initContext must be defined");
        this.pendingRecords = false;
        this.lastCheckpointId = initContext.getRestoredCheckpointId().orElse(0L);
        Preconditions.checkNotNull((Object)connectionProvider, (String)"connectionProvider must be defined");
        if (deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            Preconditions.checkArgument((executionOptions.getMaxRetries() == 0 ? 1 : 0) != 0, (Object)"JDBC XA sink requires maxRetries equal to 0, otherwise it could cause duplicates. See issue FLINK-22311 for details.");
            Preconditions.checkNotNull((Object)exactlyOnceOptions, (String)"exactlyOnceOptions must be defined");
            Preconditions.checkNotNull(recoveredState, (String)"recoveredState must be defined");
            Preconditions.checkState((recoveredState.size() <= 1 ? 1 : 0) != 0, (Object)"more than one state to recover");
            JdbcWriterState state = recoveredState.stream().findFirst().orElse(JdbcWriterState.empty());
            TransactionId transactionId = TransactionId.create(initContext.getJobId().getBytes(), initContext.getSubtaskId(), initContext.getNumberOfParallelSubtasks());
            this.jdbcTransaction = new XaTransaction(exactlyOnceOptions, transactionId, (XaConnectionProvider)connectionProvider);
            this.jdbcTransaction.open(state);
            this.jdbcTransaction.createTx(this.lastCheckpointId);
        }
        Preconditions.checkNotNull((Object)executionOptions, (String)"executionOptions must be defined");
        Preconditions.checkNotNull(queryStatement, (String)"queryStatement must be defined");
        this.jdbcOutput = new JdbcOutputFormat(connectionProvider, executionOptions, (JdbcOutputFormat.StatementExecutorFactory & Serializable)() -> JdbcBatchStatementExecutor.simple(queryStatement.query(), queryStatement::statement));
        this.jdbcOutput.open(outputSerializer);
    }

    public void write(IN element, SinkWriter.Context context) throws IOException, InterruptedException {
        if (this.deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            this.jdbcTransaction.checkState();
        }
        this.jdbcOutput.writeRecord(element);
        if (!this.pendingRecords) {
            this.pendingRecords = true;
        }
    }

    public void flush(boolean endOfInput) throws IOException, InterruptedException {
        if (this.deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE || endOfInput) {
            LOG.debug("final flush={}", (Object)endOfInput);
            this.flush();
        } else {
            this.jdbcOutput.checkFlushException();
        }
    }

    private void flush() throws IOException {
        this.jdbcOutput.flush();
        this.jdbcOutput.checkFlushException();
    }

    public Collection<JdbcCommitable> prepareCommit() throws IOException, InterruptedException {
        if (this.deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE) {
            return Collections.emptyList();
        }
        Xid currentXid = this.jdbcTransaction.getCurrentXid();
        this.jdbcTransaction.checkState();
        this.flush();
        this.jdbcTransaction.prepareTx();
        if (!this.pendingRecords) {
            this.jdbcTransaction.commitTxUntil(this.lastCheckpointId);
            return Collections.emptyList();
        }
        this.pendingRecords = false;
        JdbcCommitable committable = JdbcCommitable.of(currentXid, this.jdbcTransaction);
        LOG.debug("Committing {} committable.", (Object)committable);
        return Collections.singletonList(committable);
    }

    public List<JdbcWriterState> snapshotState(long checkpointId) throws IOException {
        if (this.deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE) {
            return Collections.emptyList();
        }
        Preconditions.checkState((checkpointId > this.lastCheckpointId ? 1 : 0) != 0, (String)"Expected %s > %s", (Object[])new Object[]{checkpointId, this.lastCheckpointId});
        if (!this.pendingRecords) {
            this.jdbcTransaction.commitTxUntil(this.lastCheckpointId);
        }
        this.lastCheckpointId = checkpointId;
        this.jdbcTransaction.createTx(this.lastCheckpointId);
        return Collections.singletonList(this.jdbcTransaction.getState());
    }

    public void close() throws Exception {
        if (this.deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE) {
            this.jdbcOutput.close();
        } else {
            this.jdbcOutput.checkFlushException();
            this.jdbcTransaction.close();
        }
    }
}

