/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.source.config;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ContinuousUnBoundingSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Duration initialDiscoveryDelay;
    private final Duration discoveryInterval;

    public ContinuousUnBoundingSettings(Duration initialDiscoveryDelay, Duration discoveryInterval) {
        this.initialDiscoveryDelay = initialDiscoveryDelay;
        this.discoveryInterval = (Duration)Preconditions.checkNotNull((Object)discoveryInterval);
    }

    public Duration getDiscoveryInterval() {
        return this.discoveryInterval;
    }

    public Duration getInitialDiscoveryDelay() {
        return this.initialDiscoveryDelay;
    }

    public String toString() {
        return "ContinuousUnBoundingSettings{initialDiscoveryDelay=" + this.initialDiscoveryDelay + ", discoveryInterval=" + this.discoveryInterval + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContinuousUnBoundingSettings that = (ContinuousUnBoundingSettings)object;
        return Objects.equals(this.initialDiscoveryDelay, that.initialDiscoveryDelay) && Objects.equals(this.discoveryInterval, that.discoveryInterval);
    }

    public int hashCode() {
        return Objects.hash(this.initialDiscoveryDelay, this.discoveryInterval);
    }
}

