/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.source.split;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.jdbc.core.datastream.source.split.CheckpointedOffset;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcSourceSplit
implements SourceSplit,
Serializable {
    private final String id;
    private final String sqlTemplate;
    @Nullable
    private final Serializable[] parameters;
    @Nullable
    private final CheckpointedOffset checkpointedOffset;

    public JdbcSourceSplit(String id, String sqlTemplate, @Nullable Serializable[] parameters, @Nullable CheckpointedOffset checkpointedOffset) {
        this.id = id;
        this.sqlTemplate = sqlTemplate;
        this.parameters = parameters;
        this.checkpointedOffset = checkpointedOffset;
    }

    @Nullable
    public CheckpointedOffset getCheckpointedOffset() {
        return this.checkpointedOffset;
    }

    public JdbcSourceSplit updateWithCheckpointedPosition(@Nullable CheckpointedOffset checkpointedOffset) {
        return new JdbcSourceSplit(this.id, this.sqlTemplate, this.parameters, checkpointedOffset);
    }

    public Optional<CheckpointedOffset> getReaderPositionOptional() {
        return Optional.ofNullable(this.checkpointedOffset);
    }

    public int getReaderPosition() {
        if (Objects.nonNull(this.checkpointedOffset)) {
            Preconditions.checkState((this.checkpointedOffset.getOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            return (int)this.checkpointedOffset.getOffset();
        }
        return 0;
    }

    public String getSqlTemplate() {
        return this.sqlTemplate;
    }

    @Nullable
    public Object[] getParameters() {
        return this.parameters;
    }

    public String splitId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcSourceSplit that = (JdbcSourceSplit)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.sqlTemplate, that.sqlTemplate) && Arrays.equals(this.parameters, that.parameters) && Objects.equals(this.checkpointedOffset, that.checkpointedOffset);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.sqlTemplate, this.checkpointedOffset);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public String toString() {
        return "JdbcSourceSplit{id='" + this.id + '\'' + ", sqlTemplate='" + this.sqlTemplate + '\'' + ", parameters=" + Arrays.toString(this.parameters) + ", checkpointedOffset=" + this.checkpointedOffset + '}';
    }
}

