/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.source.split;

import java.io.Serializable;
import java.util.Optional;
import org.apache.flink.connector.jdbc.core.datastream.source.split.CheckpointedOffset;
import org.apache.flink.connector.jdbc.core.datastream.source.split.JdbcSourceSplit;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class JdbcSourceSplitState<SplitT extends JdbcSourceSplit>
implements Serializable {
    private final SplitT split;
    private Long offset;
    private Long recordsToSkipAfterOffset;

    public JdbcSourceSplitState(SplitT split) {
        this.split = (JdbcSourceSplit)Preconditions.checkNotNull(split);
        Optional<CheckpointedOffset> readerPosition = ((JdbcSourceSplit)split).getReaderPositionOptional();
        if (readerPosition.isPresent()) {
            this.offset = readerPosition.get().getOffset();
            this.recordsToSkipAfterOffset = readerPosition.get().getRecordsAfterOffset();
        } else {
            this.offset = null;
            this.recordsToSkipAfterOffset = null;
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRecordsToSkipAfterOffset() {
        return this.recordsToSkipAfterOffset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setRecordsToSkipAfterOffset(long recordsToSkipAfterOffset) {
        this.recordsToSkipAfterOffset = recordsToSkipAfterOffset;
    }

    public void setPosition(long offset, long recordsToSkipAfterOffset) {
        this.offset = offset;
        this.recordsToSkipAfterOffset = recordsToSkipAfterOffset;
    }

    public void setPosition(CheckpointedOffset offset) {
        this.offset = offset.getOffset();
        this.recordsToSkipAfterOffset = offset.getRecordsAfterOffset();
    }

    public SplitT toJdbcSourceSplit() {
        CheckpointedOffset position = this.offset == null && this.recordsToSkipAfterOffset == 0L ? null : new CheckpointedOffset(this.offset, this.recordsToSkipAfterOffset);
        JdbcSourceSplit updatedSplit = ((JdbcSourceSplit)this.split).updateWithCheckpointedPosition(position);
        if (updatedSplit == null) {
            throw new FlinkRuntimeException("Split returned 'null' in updateWithCheckpointedPosition(): " + this.split);
        }
        if (updatedSplit.getClass() != this.split.getClass()) {
            throw new FlinkRuntimeException(String.format("Split returned different type in updateWithCheckpointedPosition(). Split type is %s, returned type is %s", this.split.getClass().getName(), updatedSplit.getClass().getName()));
        }
        return (SplitT)updatedSplit;
    }
}

